/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.Vocab;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;

public final class WordPair
implements WritableComparable {
    int f_langWord;
    int e_langWord;

    public WordPair() {
    }

    public WordPair(int e, int f) {
        this.setE(e);
        this.setF(f);
    }

    public void setFLanguageCode(int lc) {
        this.f_langWord &= 0xFFFFFF;
        this.f_langWord |= (lc <<= 24);
    }

    public void setELanguageCode(int lc) {
        this.e_langWord &= 0xFFFFFF;
        this.e_langWord |= (lc <<= 24);
    }

    public byte getFLanguageCode() {
        return (byte)(this.f_langWord >> 24);
    }

    public byte getELanguageCode() {
        return (byte)(this.e_langWord >> 24);
    }

    public void setF(int f) {
        this.f_langWord &= 0xFF000000;
        this.f_langWord |= f;
    }

    public void setE(int e) {
        this.e_langWord &= 0xFF000000;
        this.e_langWord |= e;
    }

    public int getF() {
        return this.f_langWord & 0xFFFFFF;
    }

    public int getE() {
        return this.e_langWord & 0xFFFFFF;
    }

    public void makeEMarginal() {
        this.e_langWord = -1;
    }

    public boolean isEMarginal() {
        return this.e_langWord == -1;
    }

    public void readFields(DataInput in) throws IOException {
        this.f_langWord = in.readInt();
        this.e_langWord = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.f_langWord);
        out.writeInt(this.e_langWord);
    }

    public int compareTo(Object o) {
        WordPair that = (WordPair)o;
        if (this.e_langWord != that.e_langWord) {
            return this.e_langWord - that.e_langWord;
        }
        return this.f_langWord - that.f_langWord;
    }

    public int hashCode() {
        return this.f_langWord;
    }

    public void set(WordPair rhs) {
        this.f_langWord = rhs.f_langWord;
        this.e_langWord = rhs.e_langWord;
    }

    public void swap() {
        int t = this.f_langWord;
        this.f_langWord = this.e_langWord;
        this.e_langWord = t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ F(").append(this.getFLanguageCode()).append("):").append(this.getF()).append(" , ");
        if (this.e_langWord == -1) {
            sb.append("* }");
        } else {
            sb.append("E(").append(this.getELanguageCode()).append("):").append(this.getE()).append(" }");
        }
        return sb.toString();
    }

    public String toString(Vocab vf, Vocab ve) {
        StringBuffer sb = new StringBuffer();
        sb.append("{ ").append(vf.get(this.getF())).append(" , ");
        if (this.e_langWord == -1) {
            sb.append("* }");
        } else {
            sb.append(ve.get(this.getE())).append(" }");
        }
        return sb.toString();
    }
}

