/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.AlignmentPosteriorGrid;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.alignment.AlignmentEventListener;
import edu.umd.hooka.alignment.PartialCountContainer;
import edu.umd.hooka.alignment.PerplexityReporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class AlignmentModel {
    private List<AlignmentEventListener> _listeners = new ArrayList<AlignmentEventListener>();

    public void addAlignmentListener(AlignmentEventListener ael) {
        this._listeners.add(ael);
    }

    protected void notifyUnalignablePair(PhrasePair pp, String reason) {
        for (AlignmentEventListener l : this._listeners) {
            l.notifyUnalignablePair(pp, reason);
        }
    }

    public abstract void clearModel();

    public abstract void processTrainingInstance(PhrasePair var1, Reporter var2);

    public abstract void writePartialCounts(OutputCollector<IntWritable, PartialCountContainer> var1) throws IOException;

    public abstract Alignment viterbiAlign(PhrasePair var1, PerplexityReporter var2);

    public abstract AlignmentPosteriorGrid computeAlignmentPosteriors(PhrasePair var1);
}

