/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.alignment.Refiner;
import edu.umd.hooka.alignment.RefinerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

public class HSymAlign {
    public static void main(String[] args) {
        JobConf conf = new JobConf(HSymAlign.class);
        conf.setJobName("alignment-sym");
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(MapClass.class);
        conf.setReducerClass(Reduce.class);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(500);
        String filename = "infiles";
        String outputPath = "align";
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(filename)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        try {
            JobClient.runJob((JobConf)conf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Reduce
    extends MapReduceBase
    implements Reducer<IntWritable, Text, IntWritable, Text> {
        Text alout = new Text();
        Refiner r = null;

        public void reduce(IntWritable key, Iterator<Text> values, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            if (this.r == null) {
                try {
                    this.r = RefinerFactory.getForName("grow-diag-final-and");
                }
                catch (Exception e) {
                    throw new IOException("Caught exception: " + e);
                }
            }
            Text ta = values.next();
            Text tb = values.next();
            if (ta == null || tb == null) {
                throw new IOException("Layout error!");
            }
            String sa = ta.toString();
            String sb = tb.toString();
            String e2f = sa;
            String f2e = sa;
            if (sb.charAt(0) == '0') {
                f2e = sb;
            } else {
                e2f = sb;
            }
            String[] ae2f = e2f.split("\\s*\\|\\|\\|\\s*");
            String[] af2e = f2e.split("\\s*\\|\\|\\|\\s*");
            Alignment a1 = Alignment.fromGiza(ae2f[1], ae2f[2], true);
            Alignment a2 = Alignment.fromGiza(af2e[1], af2e[2], false);
            Alignment a = this.r.refine(a1, a2);
            this.alout.set(a.toString());
            output.collect((Object)key, (Object)this.alout);
        }
    }

    public static class MapClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, Text> {
        private Text l = new Text();
        private IntWritable linenum = new IntWritable(1);

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            String comment;
            String line = value.toString();
            if (line.length() == 0) {
                return;
            }
            String[] toks = line.split("\\s*\\|\\|\\|\\s*");
            if (toks.length != 2) {
                throw new IOException("Expected input of form '0 ||| /path/to/input'");
            }
            String pfx = toks[0];
            if (!(pfx.length() == 1 || pfx.equals("0") && pfx.equals("1"))) {
                throw new IOException("Excepted transpose field to be 0 or 1");
            }
            Path p = new Path(toks[1]);
            Configuration conf = new Configuration();
            FileSystem fileSys = FileSystem.get((Configuration)conf);
            BufferedReader giza = new BufferedReader(new InputStreamReader((InputStream)fileSys.open(p), "UTF8"));
            int lc = 0;
            while ((comment = giza.readLine()) != null) {
                String e = giza.readLine();
                String f = giza.readLine();
                this.linenum.set(++lc);
                this.l.set(pfx + " ||| " + comment + " ||| " + e + " ||| " + f);
                output.collect((Object)this.linenum, (Object)this.l);
            }
        }
    }
}

