/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment;

import edu.umd.hooka.alignment.IndexedFloatArray;
import edu.umd.hooka.alignment.hmm.ATable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class PartialCountContainer
implements Writable,
Cloneable {
    public static final int CONTENT_ATABLE = 2;
    public static final int CONTENT_ARRAY = 3;
    byte type = 0;
    Writable content = null;

    public PartialCountContainer() {
    }

    private PartialCountContainer(Writable c, byte t) {
        this.content = c;
        this.type = t;
    }

    public PartialCountContainer(Writable content) {
        this.setContent(content);
    }

    public Object clone() {
        Writable nc = null;
        if (this.type == 2) {
            nc = (Writable)((ATable)this.content).clone();
        } else if (this.type == 3) {
            nc = (Writable)((IndexedFloatArray)this.content).clone();
        } else {
            throw new RuntimeException("Bad type");
        }
        return new PartialCountContainer(nc, this.type);
    }

    public void setContent(Writable content) {
        if (content instanceof ATable) {
            this.type = (byte)2;
        } else if (content instanceof IndexedFloatArray) {
            this.type = (byte)3;
        } else {
            throw new RuntimeException("Don't know how to wrap " + content);
        }
        this.content = content;
    }

    public Writable getContent() {
        return this.content;
    }

    public int getType() {
        return this.type;
    }

    public void plusEquals(PartialCountContainer rhs) {
        if (rhs.type != this.type) {
            throw new RuntimeException("Type mismatch!");
        }
        if (this.type == 2) {
            ((ATable)this.content).plusEquals((ATable)rhs.content);
        } else if (this.type == 3) {
            ((IndexedFloatArray)this.content).plusEquals((IndexedFloatArray)rhs.content);
        } else {
            throw new RuntimeException("Bad type");
        }
    }

    public void normalize(boolean variationalBayes, float alpha) {
        if (this.type == 2) {
            ((ATable)this.content).normalize();
        } else if (this.type == 3) {
            if (variationalBayes) {
                ((IndexedFloatArray)this.content).normalize_variationalBayes(alpha);
            } else {
                ((IndexedFloatArray)this.content).normalize(alpha);
            }
        } else {
            throw new RuntimeException("Bad type");
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.type = in.readByte();
        if (this.type == 2) {
            this.content = new ATable();
        } else if (this.type == 3) {
            this.content = new IndexedFloatArray();
        } else {
            throw new RuntimeException("Bad content type!");
        }
        this.content.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.type);
        this.content.write(out);
    }

    public String toString() {
        return "T(" + this.type + "): " + this.content;
    }
}

