/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment;

public class PerplexityReporter {
    double totalProb = 0.0;
    int totalWords = 0;

    public void addFactor(double logProb, int wordCount) {
        this.totalWords += wordCount;
        this.totalProb -= logProb;
    }

    public void plusEquals(PerplexityReporter rhs) {
        this.totalWords += rhs.totalWords;
        this.totalProb += rhs.totalProb;
    }

    public double getTotalLogProb() {
        return this.totalProb;
    }

    public int getTotalWordCount() {
        return this.totalWords;
    }

    public double getCrossEntropy() {
        return this.totalProb / (double)this.totalWords;
    }

    public void reset() {
        this.totalProb = 0.0;
        this.totalWords = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CROSS ENTROPY: ").append(this.getCrossEntropy()).append("\tPERPLEXITY: ").append(Math.pow(2.0, this.getCrossEntropy()));
        return sb.toString();
    }
}

