/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.alignment.Refiner;
import java.util.ArrayList;

public class RefinerFactory {
    static final String GROW_DIAG_FINAL_AND = "grow-diag-final-and";
    static final String INTERSECTION = "intersection";
    static final String UNION = "union";
    static final String GROW_DIAG_FINAL = "grow-diag-final";
    static final String OCH = "och";

    static void grow(Alignment a, Pred pred, boolean idem, Alignment pot) {
        int flen = a.getFLength();
        int elen = a.getELength();
        if (idem) {
            for (int i = 0; i < flen; ++i) {
                for (int j = 0; j < elen; ++j) {
                    if (!pot.aligned(i, j) || a.aligned(i, j) || !pred.eval(a, i, j)) continue;
                    a.align(i, j);
                }
            }
        } else {
            boolean flag;
            ArrayList<Pair> p = new ArrayList<Pair>();
            for (int i = 0; i < flen; ++i) {
                for (int j = 0; j < elen; ++j) {
                    if (!pot.aligned(i, j) || a.aligned(i, j)) continue;
                    p.add(new Pair(i, j));
                }
            }
            int plen = p.size();
            Pair[] pairs = new Pair[plen];
            p.toArray(pairs);
            p = null;
            do {
                int cur = 0;
                flag = false;
                for (int pi = 0; pi < plen; ++pi) {
                    Pair pp = pairs[pi];
                    if (pred.eval(a, pp.i, pp.j)) {
                        a.align(pp.i, pp.j);
                        flag = true;
                        continue;
                    }
                    pairs[cur] = pp;
                    ++cur;
                }
                plen = cur;
            } while (flag);
        }
    }

    public static Refiner getForName(String name) throws Exception {
        if (name.equals(INTERSECTION)) {
            return new IntersectionRefiner();
        }
        if (name.equals(UNION)) {
            return new UnionRefiner();
        }
        if (name.equals(GROW_DIAG_FINAL_AND)) {
            return new GrowDiagFinalAndRefiner();
        }
        throw new Exception("Unknown refinement algorithm: " + name);
    }

    static class Pair {
        public int i;
        public int j;

        public Pair(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }

    static class GrowDiagFinalAndRefiner
    extends Refiner {
        static Koehn koehn = new Koehn();
        static KoehnFinal koehnFinal = new KoehnFinal();

        GrowDiagFinalAndRefiner() {
        }

        @Override
        public Alignment refine(Alignment a2, Alignment a1) {
            Alignment au = Alignment.union(a1, a2);
            Alignment a = Alignment.intersect(a1, a2);
            RefinerFactory.grow(a, koehn, false, au);
            RefinerFactory.grow(a, koehnFinal, true, a1);
            RefinerFactory.grow(a, koehnFinal, true, a2);
            return a;
        }
    }

    static class UnionRefiner
    extends Refiner {
        UnionRefiner() {
        }

        @Override
        public Alignment refine(Alignment a1, Alignment a2) {
            return Alignment.union(a1, a2);
        }
    }

    static class IntersectionRefiner
    extends Refiner {
        IntersectionRefiner() {
        }

        @Override
        public Alignment refine(Alignment a1, Alignment a2) {
            return Alignment.intersect(a1, a2);
        }
    }

    static class KoehnFinal
    extends Pred {
        KoehnFinal() {
        }

        @Override
        public boolean eval(Alignment a, int i, int j) {
            return !a.rookAligned(i, j);
        }
    }

    static class Koehn
    extends Pred {
        Koehn() {
        }

        @Override
        public boolean eval(Alignment a, int i, int j) {
            return !a.doubleRookAligned(i, j) && a.neighborAligned(i, j);
        }
    }

    static class Och
    extends Pred {
        Och() {
        }

        @Override
        public boolean eval(Alignment a, int i, int j) {
            return !a.rookAligned(i, j) || a.neighborAligned(i, j) && !a.lneighborAligned(i, j);
        }
    }

    static abstract class Pred {
        Pred() {
        }

        public abstract boolean eval(Alignment var1, int var2, int var3);
    }
}

