/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment.hmm;

import edu.umd.hooka.alignment.hmm.ATable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Test;

public class ATableTest
extends TestCase {
    @Test
    public void testNormalize() {
        ATable at = new ATable(true, 1, 10);
        at.add(1, 'a', 99, 1.0f);
        at.add(-1, 'a', 99, 0.5f);
        at.add(0, 'a', 99, 0.5f);
        at.normalize();
        ATableTest.assertEquals((float)0.25f, (float)at.get(0, 'a'), (float)0.01f);
        ATableTest.assertEquals((float)0.5f, (float)at.get(1, 'a'), (float)0.01f);
    }

    @Test
    public void testReadFields() {
        try {
            File temp = File.createTempFile("ttable", null);
            temp.deleteOnExit();
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(temp));
            ATable at = new ATable(true, 1, 10);
            at.add(1, 'a', 99, 1.0f);
            at.add(-1, 'a', 99, 0.5f);
            at.add(0, 'a', 99, 0.5f);
            at.normalize();
            ATableTest.assertEquals((float)0.25f, (float)at.get(0, 'a'), (float)0.01f);
            ATableTest.assertEquals((float)0.5f, (float)at.get(1, 'a'), (float)0.01f);
            System.err.println(at);
            at.write(dos);
            dos.close();
            System.err.println("Size of at on disk: " + dos.size());
            DataInputStream dis = new DataInputStream(new FileInputStream(temp));
            ATable at2 = new ATable();
            at2.readFields(dis);
            System.err.println(at2);
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            ATableTest.fail((String)("Caught " + e));
        }
    }

    @Test
    public void testDistribution() {
        ATable at = new ATable(true, 1, 100);
        at.normalize();
        System.out.println(at);
    }

    @Test
    public void testNonHomogeneous() {
        ATable at = new ATable(false, 10, 10);
        at.normalize();
        System.out.println(at);
    }
}

