/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment.hmm;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.AlignmentPosteriorGrid;
import edu.umd.hooka.Phrase;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.alignment.PerplexityReporter;
import edu.umd.hooka.alignment.hmm.ATable;
import edu.umd.hooka.alignment.hmm.HMM;
import edu.umd.hooka.alignment.hmm.HMM_NullWord;
import edu.umd.hooka.ttables.TTable;
import edu.umd.hooka.ttables.TTable_monolithic;
import junit.framework.TestCase;

public class HMMTest
extends TestCase {
    HMM hmm;

    public void testHMM() {
        ATable at = new ATable(true, 1, 5);
        int[] e1 = new int[]{-1, 0, 3, 6};
        int[] ef = new int[]{1, 2, 3, 1, 2, 3};
        TTable_monolithic tt = new TTable_monolithic(e1, ef, 4);
        tt.set(1, 1, 0.1f);
        tt.set(1, 2, 0.7f);
        tt.set(1, 3, 0.2f);
        tt.set(2, 1, 0.5f);
        tt.set(2, 2, 0.4f);
        tt.set(2, 3, 0.1f);
        at.normalize();
        int[] fw = new int[]{2, 1, 2, 3};
        int[] ew = new int[]{1, 2, 1};
        Phrase f = new Phrase(fw, 1);
        Phrase e = new Phrase(ew, 1);
        PhrasePair pp = new PhrasePair(f, e);
        this.hmm = new HMM((TTable)tt, at);
        this.hmm.buildHMMTables(pp);
        this.hmm.baumWelch(pp, null);
        TTable_monolithic tc = (TTable_monolithic)tt.clone();
        tc.clear();
        ATable ac = (ATable)at.clone();
        ac.clear();
        this.hmm.addPartialTranslationCountsToTTable(tc);
        this.hmm.addPartialJumpCountsToATable(ac);
        System.out.println("COUNTS:\n" + tc);
        tc.normalize();
        ac.normalize();
        System.out.println("OLD:\n" + at);
        System.out.println("NEW:\n" + ac);
        System.out.println("\nnew:\n" + tc);
        PerplexityReporter cr = new PerplexityReporter();
        Alignment a = this.hmm.viterbiAlign(pp, cr);
        double ce1 = cr.getCrossEntropy();
        System.out.println(a.toStringVisual() + "\n" + cr);
        HMMTest.assertTrue((boolean)a.aligned(0, 0));
        System.out.println(this.hmm.backtrace);
        this.hmm = new HMM((TTable)tc, ac);
        this.hmm.buildHMMTables(pp);
        cr.reset();
        a = this.hmm.viterbiAlign(pp, cr);
        double ce2 = cr.getCrossEntropy();
        HMMTest.assertTrue((ce1 > ce2 ? 1 : 0) != 0);
        assert (tc.get(1, 1) > 0.0f);
        System.out.println(a.toStringVisual() + "\n" + cr + "\nPG::\n" + this.hmm.computeAlignmentPosteriors(pp));
        HMMTest.assertEquals((int)a.getELength(), (int)e.size());
        HMMTest.assertEquals((int)a.getFLength(), (int)f.size());
    }

    public void testHMM2() {
        ATable at = new ATable(true, 1, 5);
        int[] e1 = new int[]{-1, 0, 2, 4};
        int[] ef = new int[]{1, 2, 1, 2};
        TTable_monolithic tt = new TTable_monolithic(e1, ef, 4);
        tt.set(1, 1, 0.3f);
        tt.set(1, 2, 0.7f);
        tt.set(2, 1, 0.9f);
        tt.set(2, 2, 0.1f);
        at.add(1, 'a', 999, 0.3f);
        at.add(0, 'a', 999, 0.5f);
        at.add(-1, 'a', 999, 0.4f);
        at.add(-2, 'a', 999, 0.2f);
        at.normalize();
        int[] fw = new int[]{1, 2};
        int[] ew = new int[]{2, 1};
        Phrase f = new Phrase(fw, 1);
        Phrase e = new Phrase(ew, 1);
        PhrasePair pp = new PhrasePair(f, e);
        this.hmm = new HMM((TTable)tt, at);
        this.hmm.buildHMMTables(pp);
        PerplexityReporter cr = new PerplexityReporter();
        Alignment a = this.hmm.viterbiAlign(pp, cr);
        HMMTest.assertEquals((int)a.getELength(), (int)e.size());
        HMMTest.assertEquals((int)a.getFLength(), (int)f.size());
        System.out.println(a.toStringVisual() + "\n" + cr);
    }

    public void testUnalignable() {
        ATable at = new ATable(true, 1, 10);
        int[] e1 = new int[]{-1, 0, 2, 4};
        int[] ef = new int[]{1, 2, 1, 2};
        TTable_monolithic tt = new TTable_monolithic(e1, ef, 4);
        tt.set(1, 1, 0.2f);
        tt.set(1, 2, 0.8f);
        tt.set(2, 1, 0.9f);
        tt.set(2, 2, 0.1f);
        at.add(4, 'a', 999, 0.05f);
        at.add(3, 'a', 999, 0.05f);
        at.add(2, 'a', 999, 0.05f);
        at.add(1, 'a', 999, 0.3f);
        at.add(0, 'a', 999, 0.5f);
        at.add(-1, 'a', 999, 0.4f);
        at.add(-2, 'a', 999, 0.5f);
        at.add(-3, 'a', 999, 0.05f);
        at.add(-4, 'a', 999, 0.05f);
        at.add(-5, 'a', 999, 0.05f);
        at.normalize();
        int[] fw = new int[]{2, 1, 2, 3, 2, 2, 2};
        int[] ew = new int[]{2, 1, 1, 1, 2};
        Phrase f = new Phrase(fw, 1);
        Phrase e = new Phrase(ew, 1);
        PhrasePair pp = new PhrasePair(f, e);
        tt.normalize();
        this.hmm = new HMM((TTable)tt, at);
        this.hmm.buildHMMTables(pp);
        PerplexityReporter cr = new PerplexityReporter();
        Alignment a = this.hmm.viterbiAlign(pp, cr);
        HMMTest.assertEquals((int)a.getELength(), (int)e.size());
        HMMTest.assertEquals((int)a.getFLength(), (int)f.size());
        System.err.println(this.hmm.emission);
        System.err.println(this.hmm.transition);
        System.out.println(tt);
        System.err.println(this.hmm.viterbi);
        System.err.println(this.hmm.backtrace);
    }

    public void testNullHMM() {
        ATable at = new ATable(true, 1, 5);
        int[] e1 = new int[]{-1, 0, 3, 6};
        int[] ef = new int[]{1, 2, 3, 1, 2, 3};
        TTable_monolithic tt = new TTable_monolithic(e1, ef, 4);
        tt.set(0, 1, 0.1f);
        tt.set(0, 2, 0.1f);
        tt.set(0, 3, 0.8f);
        tt.set(1, 1, 0.3f);
        tt.set(1, 2, 0.7f);
        tt.set(2, 1, 0.9f);
        tt.set(2, 2, 0.1f);
        at.add(1, 'a', 999, 0.3f);
        at.add(0, 'a', 999, 0.5f);
        at.add(-1, 'a', 999, 0.4f);
        at.add(-2, 'a', 999, 0.2f);
        at.normalize();
        int[] fw = new int[]{1, 3, 2, 1};
        int[] ew = new int[]{2, 1, 2};
        Phrase f = new Phrase(fw, 1);
        Phrase e = new Phrase(ew, 1);
        PhrasePair pp = new PhrasePair(f, e);
        this.hmm = new HMM_NullWord((TTable)tt, at, -1.0);
        this.hmm.buildHMMTables(pp);
        this.hmm.baumWelch(pp, null);
        TTable_monolithic tc = (TTable_monolithic)tt.clone();
        tc.clear();
        ATable ac = (ATable)at.clone();
        ac.clear();
        this.hmm.addPartialTranslationCountsToTTable(tc);
        this.hmm.addPartialJumpCountsToATable(ac);
        System.out.println("COUNTS:\n" + tc);
        tc.normalize();
        ac.normalize();
        PerplexityReporter cr = new PerplexityReporter();
        Alignment a = this.hmm.viterbiAlign(pp, cr);
        HMMTest.assertEquals((int)a.getELength(), (int)e.size());
        HMMTest.assertEquals((int)a.getFLength(), (int)f.size());
        AlignmentPosteriorGrid pg = this.hmm.computeAlignmentPosteriors(pp);
        System.out.println(a.toStringVisual() + "\nPG:\n" + pg + "\n" + cr + "\n");
        System.out.println(this.hmm.emission);
        System.out.println(this.hmm.transition);
        System.out.println("Done NULL");
    }
}

