/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment.model1;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.AlignmentPosteriorGrid;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.alignment.CrossEntropyCounters;
import edu.umd.hooka.alignment.PerplexityReporter;
import edu.umd.hooka.alignment.model1.Model1Base;
import edu.umd.hooka.ttables.TTable;
import java.util.Arrays;
import org.apache.hadoop.mapred.Reporter;

public class Model1
extends Model1Base {
    float[] totals = null;
    protected TTable tmodel = null;

    public Model1(TTable ttable, boolean useNullWord) {
        super(useNullWord);
        this.tmodel = ttable;
    }

    @Override
    public void clearModel() {
        this.tmodel = null;
        this.totals = null;
    }

    @Override
    public void processTrainingInstance(PhrasePair pp, Reporter reporter) {
        this.initializeCountTableForSentencePair(pp);
        int[] fw = pp.getF().getWords();
        int[] ew = pp.getE().getWords();
        if (this.totals == null) {
            this.totals = new float[214350];
        } else {
            Arrays.fill(this.totals, 0.0f);
        }
        if (this._includeEnglishNullWord) {
            int[] arr$ = fw;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int fj;
                int n = fj = arr$[i$];
                this.totals[n] = this.totals[n] + this.tmodel.get(0, fj);
            }
        }
        for (int ei : ew) {
            int[] arr$ = fw;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int fj;
                int n = fj = arr$[i$];
                this.totals[n] = this.totals[n] + this.tmodel.get(ei, fj);
            }
        }
        float totalLogProb = 0.0f;
        for (int j = 0; j < fw.length; ++j) {
            int fj = fw[j];
            float totalProb = this.totals[fj];
            totalLogProb = (float)((double)totalLogProb + Math.log(totalProb));
            for (int i = 0; i <= ew.length; ++i) {
                int ei = i > 0 ? ew[i - 1] : 0;
                this.addTranslationCount(i, j, this.tmodel.get(ei, fj) / totalProb);
            }
        }
        if (reporter != null) {
            totalLogProb = (float)((double)totalLogProb - (double)fw.length * Math.log(1.0f + (float)ew.length));
            reporter.incrCounter((Enum)CrossEntropyCounters.LOGPROB, (long)(-totalLogProb));
            reporter.incrCounter((Enum)CrossEntropyCounters.WORDCOUNT, (long)fw.length);
            reporter.progress();
        }
    }

    @Override
    public AlignmentPosteriorGrid computeAlignmentPosteriors(PhrasePair pp) {
        AlignmentPosteriorGrid res = new AlignmentPosteriorGrid(pp);
        int[] fw = pp.getF().getWords();
        int[] ew = pp.getE().getWords();
        if (this.totals == null) {
            this.totals = new float[214350];
        } else {
            Arrays.fill(this.totals, 0.0f);
        }
        if (this._includeEnglishNullWord) {
            int[] arr$ = fw;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int fj;
                int n = fj = arr$[i$];
                this.totals[n] = this.totals[n] + this.tmodel.get(0, fj);
            }
        }
        for (int ei : ew) {
            int[] arr$ = fw;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int fj;
                int n = fj = arr$[i$];
                this.totals[n] = this.totals[n] + this.tmodel.get(ei, fj);
            }
        }
        float totalLogProb = 0.0f;
        for (int j = 0; j < fw.length; ++j) {
            int fj = fw[j];
            float totalProb = this.totals[fj];
            totalLogProb = (float)((double)totalLogProb + Math.log(totalProb));
            int start = 1;
            if (this._includeEnglishNullWord) {
                start = 0;
            }
            for (int i = start; i <= ew.length; ++i) {
                int ei = i > 0 ? ew[i - 1] : 0;
                float post = this.tmodel.get(ei, fj) / totalProb;
                res.setAlignmentPointPosterior(j, i, post);
            }
        }
        return res;
    }

    @Override
    public Alignment viterbiAlign(PhrasePair sentence, PerplexityReporter viterbiPerp) {
        int[] es = sentence.getE().getWords();
        int[] fs = sentence.getF().getWords();
        float threshold = 0.27f;
        Alignment res = new Alignment(fs.length, es.length);
        AlignmentPosteriorGrid g = this.computeAlignmentPosteriors(sentence);
        for (int j = 0; j < fs.length; ++j) {
            for (int i = 1; i < es.length; ++i) {
                float post = g.getAlignmentPointPosterior(j, i);
                if (!(post > threshold)) continue;
                res.align(j, i - 1);
            }
        }
        return res;
    }

    public Alignment realViterbiAlign(PhrasePair sentence, PerplexityReporter viterbiPerp) {
        int[] es = sentence.getE().getWords();
        int[] fs = sentence.getF().getWords();
        Alignment res = new Alignment(fs.length, es.length);
        float viterbiScore = 0.0f;
        for (int j = 0; j < fs.length; ++j) {
            float bestProb = -1.0f;
            int besti = -1;
            int starti = 0;
            if (this._includeEnglishNullWord) {
                starti = -1;
            }
            for (int i = starti; i < es.length; ++i) {
                float curProb = 0.0f;
                curProb = i == -1 ? this.tmodel.get(0, fs[j]) : this.tmodel.get(es[i], fs[j]);
                if (!(curProb > bestProb)) continue;
                bestProb = curProb;
                besti = i;
            }
            if (besti >= 0) {
                res.align(j, besti);
            }
            viterbiScore = (float)((double)viterbiScore + Math.log(bestProb));
        }
        viterbiPerp.addFactor((double)viterbiScore - (double)fs.length * Math.log((double)es.length + 1.0), fs.length);
        return res;
    }
}

