/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.ttables;

import edu.umd.hooka.Vocab;
import edu.umd.hooka.alignment.HadoopAlign;
import edu.umd.hooka.ttables.TTable_monolithic;
import edu.umd.hooka.ttables.TTable_monolithic_IFAs;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TTableTest
extends TestCase {
    TTable_monolithic tt;
    Vocab vf;
    Vocab ve;

    public TTableTest(String name) {
        super(name);
        int[] e = new int[]{-1, 0, 3, 5};
        int[] ef = new int[]{1, 2, 4, 1, 2};
        this.tt = new TTable_monolithic(e, ef, 4);
    }

    public void testGet() {
        int[] arr1;
        Configuration conf = new Configuration();
        Vocab vocabEn_e2f = null;
        Vocab vocabDe_e2f = null;
        Vocab vocabEn_f2e = null;
        Vocab vocabDe_f2e = null;
        TTable_monolithic_IFAs ttable_de2en = null;
        TTable_monolithic_IFAs ttable_en2de = null;
        try {
            vocabEn_e2f = HadoopAlign.loadVocab(new Path("data/vocab.en-de.en"), conf);
            vocabDe_e2f = HadoopAlign.loadVocab(new Path("data/vocab.en-de.de"), conf);
            vocabEn_f2e = HadoopAlign.loadVocab(new Path("data/vocab.de-en.en"), conf);
            vocabDe_f2e = HadoopAlign.loadVocab(new Path("data/vocab.de-en.de"), conf);
            ttable_de2en = new TTable_monolithic_IFAs(FileSystem.get((Configuration)conf), new Path("data/ttable.de-en"), true);
            ttable_en2de = new TTable_monolithic_IFAs(FileSystem.get((Configuration)conf), new Path("data/ttable.en-de"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int e1 = vocabEn_e2f.get("book");
        int f1 = vocabDe_e2f.get("buch");
        System.out.println(vocabDe_e2f.get(f1) + "=" + ttable_en2de.get(e1, f1));
        System.out.println(vocabEn_f2e.get(e1) + "=" + ttable_de2en.get(f1, e1));
        for (int f : arr1 = ttable_en2de.get(e1).getTranslations(0.01f)) {
            System.out.println(vocabDe_e2f.get(f) + "=" + ttable_en2de.get(e1, f));
        }
        e1 = vocabEn_f2e.get("book");
        f1 = vocabDe_f2e.get("buch");
        System.out.println(vocabDe_f2e.get(f1) + "=" + ttable_de2en.get(f1, e1));
        System.out.println(vocabDe_f2e.get(f1) + "=" + ttable_de2en.get(f1, e1));
        System.out.println(ttable_de2en.getMaxE() == vocabDe_f2e.size() - 1);
        System.out.println(ttable_en2de.getMaxE() == vocabEn_e2f.size() - 1);
    }

    public void testAdd() {
        this.tt.clear();
        this.tt.add(1, 1, 0.1f);
        this.tt.add(1, 2, 0.1f);
        this.tt.add(1, 4, 0.1f);
        this.tt.add(1, 4, 0.2f);
        float f = this.tt.get(1, 4);
        TTableTest.assertEquals((Object)Float.valueOf(0.3f), (Object)Float.valueOf(f));
    }

    public void testNormalize() {
        this.tt.clear();
        this.tt.add(1, 1, 0.1f);
        this.tt.add(1, 2, 0.2f);
        this.tt.add(1, 4, 0.1f);
        this.tt.add(2, 1, 0.2f);
        this.tt.normalize();
        TTableTest.assertEquals((Object)Float.valueOf(0.25f), (Object)Float.valueOf(this.tt.get(1, 1)));
        TTableTest.assertEquals((Object)Float.valueOf(0.5f), (Object)Float.valueOf(this.tt.get(1, 2)));
        TTableTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.tt.get(2, 1)));
    }

    public void testTTIFA() {
    }

    public void testGetCoord() {
        int[] e1 = new int[]{-1, 0, 3, 6};
        int[] ef = new int[]{1, 2, 3, 1, 2, 3};
        TTable_monolithic tt = new TTable_monolithic(e1, ef, 4);
        tt.set(1, 1, 0.1f);
        tt.set(1, 2, 0.7f);
        tt.set(1, 3, 0.2f);
        tt.set(2, 1, 0.5f);
        tt.set(2, 2, 0.4f);
        tt.set(2, 3, 0.1f);
    }

    public void testSet() {
        this.tt.clear();
        this.tt.set(1, 1, 0.8f);
        TTableTest.assertEquals((Object)Float.valueOf(0.8f), (Object)Float.valueOf(this.tt.get(1, 1)));
        this.tt.set(1, 1, 0.2f);
        TTableTest.assertEquals((Object)Float.valueOf(0.2f), (Object)Float.valueOf(this.tt.get(1, 1)));
    }

    public void testReadFields() {
        try {
            File temp = File.createTempFile("ttable", null);
            temp.deleteOnExit();
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(temp));
            this.tt.clear();
            this.tt.set(1, 1, 0.08f);
            this.tt.set(2, 1, 0.4f);
            this.tt.set(2, 2, 0.3f);
            this.tt.set(0, 1, 0.04f);
            this.tt.set(0, 2, 0.25f);
            TTableTest.assertEquals((Object)Float.valueOf(0.08f), (Object)Float.valueOf(this.tt.get(1, 1)));
            System.err.println(this.tt);
            this.tt.write(dos);
            dos.close();
            System.err.println("Size of tt on disk: " + dos.size());
            DataInputStream dis = new DataInputStream(new FileInputStream(temp));
            TTable_monolithic tt2 = new TTable_monolithic();
            tt2.readFields(dis);
            System.err.println(tt2);
            TTableTest.assertEquals((Object)Float.valueOf(0.04f), (Object)Float.valueOf(this.tt.get(0, 1)));
            TTableTest.assertEquals((Object)Float.valueOf(0.08f), (Object)Float.valueOf(tt2.get(1, 1)));
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            TTableTest.fail((String)("Caught " + e));
        }
    }

    public void testWriteAsIndexedFloatArray() {
        try {
            File temp = File.createTempFile("ifa", null);
            temp.deleteOnExit();
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(temp));
            this.tt.clear();
            this.tt.set(1, 1, 0.08f);
            this.tt.set(2, 1, 0.4f);
            this.tt.set(2, 2, 0.3f);
            this.tt.set(0, 1, 0.04f);
            TTableTest.assertEquals((Object)Float.valueOf(0.08f), (Object)Float.valueOf(this.tt.get(1, 1)));
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            TTableTest.fail((String)("Caught " + e));
        }
    }

    public void testSliced() {
    }
}

