/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.ttables;

import edu.umd.hooka.alignment.IndexedFloatArray;
import edu.umd.hooka.ttables.TTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TTable_monolithic_IFAs
extends TTable
implements Cloneable {
    IndexedFloatArray[] _data;
    Path _datapath;
    FileSystem _fs;
    int eLen;
    int indexLen;

    @Override
    public Object clone() {
        TTable_monolithic_IFAs res = new TTable_monolithic_IFAs();
        res._data = new IndexedFloatArray[this._data.length];
        for (int i = 0; i < this._data.length; ++i) {
            res._data[i] = (IndexedFloatArray)this._data[i].clone();
        }
        res.eLen = this.eLen;
        res.indexLen = this.indexLen;
        return res;
    }

    public TTable_monolithic_IFAs() {
        this._data = new IndexedFloatArray[10];
    }

    public TTable_monolithic_IFAs(FileSystem fs, Path p, boolean load) throws IOException {
        this._fs = fs;
        this._datapath = p;
        if (load) {
            this.readFields((DataInput)this._fs.open(this._datapath));
        } else {
            this._data = new IndexedFloatArray[10];
        }
    }

    public int getMaxF() {
        return this._data[0].size() - 1;
    }

    public int getMaxE() {
        return this._data.length - 1;
    }

    private final void ensureSize(int e) {
        if (e >= this._data.length) {
            IndexedFloatArray[] x = new IndexedFloatArray[(int)((float)e * 1.5f)];
            System.arraycopy(this._data, 0, x, 0, this._data.length);
            this._data = x;
        }
    }

    @Override
    public void add(int e, int f, float delta) {
        this.ensureSize(e);
        this._data[e].add(f, delta);
    }

    @Override
    public void set(int e, int f, float value) {
        this._data[e].set(f, value);
    }

    @Override
    public void set(int e, IndexedFloatArray fs) {
        this.ensureSize(e);
        if (this._data[e] == null) {
            this._data[e] = (IndexedFloatArray)fs.clone();
        } else {
            this._data[e].copyFrom(fs);
        }
    }

    @Override
    public float get(int e, int f) {
        return this._data[e].get(f);
    }

    public IndexedFloatArray get(int e) {
        return this._data[e];
    }

    public void prune(float threshold) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void normalize() {
        for (IndexedFloatArray x : this._data) {
            if (x == null) continue;
            x.normalize();
        }
    }

    public void readFields(DataInput in) throws IOException {
        int len = in.readInt();
        this._data = new IndexedFloatArray[len];
        for (int i = 0; i < len; ++i) {
            this._data[i] = new IndexedFloatArray();
            this._data[i].readFields(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        int max = 0;
        for (int len = 0; len < this._data.length; ++len) {
            if (this._data[len] == null) continue;
            max = len + 1;
        }
        out.writeInt(max);
        IndexedFloatArray nullA = new IndexedFloatArray();
        for (int i = 0; i < max; ++i) {
            if (this._data[i] == null) {
                nullA.write(out);
                continue;
            }
            this._data[i].write(out);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int e = 0; e < this._data.length; ++e) {
            sb.append("e=").append(e).append(' ').append(this._data[e]).append('\n');
        }
        return sb.toString();
    }

    @Override
    public void write() throws IOException {
        FSDataOutputStream s = this._fs.create(this._datapath);
        this.write((DataOutput)s);
        s.close();
    }

    @Override
    public void clear() {
        for (IndexedFloatArray i : this._data) {
            if (i == null) continue;
            i.clear();
        }
    }
}

