package edu.umd.hooka.corpora;

import java.util.HashMap;

public class Language {
	static HashMap<String, Language> lmap = new HashMap<String, Language>();
	static {
		lmap.put("aa", new Language("aa","Afar"));
		lmap.put("ab", new Language("ab","Abkhazian"));
		lmap.put("ae", new Language("ae","Avestan"));
		lmap.put("af", new Language("af","Afrikaans"));
		lmap.put("ak", new Language("ak","Akan"));
		lmap.put("am", new Language("am","Amharic"));
		lmap.put("an", new Language("an","Aragonese"));
		lmap.put("ar", new Language("ar","Arabic"));
		lmap.put("as", new Language("as","Assamese"));
		lmap.put("av", new Language("av","Avaric"));
		lmap.put("ay", new Language("ay","Aymara"));
		lmap.put("az", new Language("az","Azerbaijani"));
		lmap.put("ba", new Language("ba","Bashkir"));
		lmap.put("be", new Language("be","Belarusian"));
		lmap.put("bg", new Language("bg","Bulgarian"));
		lmap.put("bh", new Language("bh","Bihari"));
		lmap.put("bi", new Language("bi","Bislama"));
		lmap.put("bm", new Language("bm","Bambara"));
		lmap.put("bn", new Language("bn","Bengali"));
		lmap.put("bo", new Language("bo","Tibetan"));
		lmap.put("br", new Language("br","Breton"));
		lmap.put("bs", new Language("bs","Bosnian"));
		lmap.put("ca", new Language("ca","Catalan"));
		lmap.put("ce", new Language("ce","Chechen"));
		lmap.put("ch", new Language("ch","Chamorro"));
		lmap.put("co", new Language("co","Corsican"));
		lmap.put("cr", new Language("cr","Cree"));
		lmap.put("cs", new Language("cs","Czech"));
		lmap.put("cu", new Language("cu","Church Slavic"));
		lmap.put("cv", new Language("cv","Chuvash"));
		lmap.put("cy", new Language("cy","Welsh"));
		lmap.put("da", new Language("da","Danish"));
		lmap.put("de", new Language("de","German"));
		lmap.put("dv", new Language("dv","Divehi"));
		lmap.put("dz", new Language("dz","Dzongkha"));
		lmap.put("ee", new Language("ee","Ewe"));
		lmap.put("el", new Language("el","Greek"));
		lmap.put("en", new Language("en","English"));
		lmap.put("eo", new Language("eo","Esperanto"));
		lmap.put("es", new Language("es","Spanish"));
		lmap.put("et", new Language("et","Estonian"));
		lmap.put("eu", new Language("eu","Basque"));
		lmap.put("fa", new Language("fa","Persian"));
		lmap.put("ff", new Language("ff","Fulah"));
		lmap.put("fi", new Language("fi","Finnish"));
		lmap.put("fj", new Language("fj","Fijian"));
		lmap.put("fo", new Language("fo","Faroese"));
		lmap.put("fr", new Language("fr","French"));
		lmap.put("fy", new Language("fy","Western Frisian"));
		lmap.put("ga", new Language("ga","Irish"));
		lmap.put("gd", new Language("gd","Scottish Gaelic"));
		lmap.put("gl", new Language("gl","Galician"));
		lmap.put("gn", new Language("gn","Guarani"));
		lmap.put("gu", new Language("gu","Gujarati"));
		lmap.put("gv", new Language("gv","Manx"));
		lmap.put("ha", new Language("ha","Hausa"));
		lmap.put("he", new Language("he","Hebrew"));
		lmap.put("hi", new Language("hi","Hindi"));
		lmap.put("ho", new Language("ho","Hiri Motu"));
		lmap.put("hr", new Language("hr","Croatian"));
		lmap.put("ht", new Language("ht","Haitian"));
		lmap.put("hu", new Language("hu","Hungarian"));
		lmap.put("hy", new Language("hy","Armenian"));
		lmap.put("hz", new Language("hz","Herero"));
		lmap.put("ia", new Language("ia","Interlingua (International Auxiliary Language Association)"));
		lmap.put("id", new Language("id","Indonesian"));
		lmap.put("ie", new Language("ie","Interlingue"));
		lmap.put("ig", new Language("ig","Igbo"));
		lmap.put("ii", new Language("ii","Sichuan Yi"));
		lmap.put("ik", new Language("ik","Inupiaq"));
		lmap.put("io", new Language("io","Ido"));
		lmap.put("is", new Language("is","Icelandic"));
		lmap.put("it", new Language("it","Italian"));
		lmap.put("iu", new Language("iu","Inuktitut"));
		lmap.put("ja", new Language("ja","Japanese"));
		lmap.put("jv", new Language("jv","Javanese"));
		lmap.put("ka", new Language("ka","Georgian"));
		lmap.put("kg", new Language("kg","Kongo"));
		lmap.put("ki", new Language("ki","Kikuyu"));
		lmap.put("kj", new Language("kj","Kwanyama"));
		lmap.put("kk", new Language("kk","Kazakh"));
		lmap.put("kl", new Language("kl","Kalaallisut"));
		lmap.put("km", new Language("km","Khmer"));
		lmap.put("kn", new Language("kn","Kannada"));
		lmap.put("ko", new Language("ko","Korean"));
		lmap.put("kr", new Language("kr","Kanuri"));
		lmap.put("ks", new Language("ks","Kashmiri"));
		lmap.put("ku", new Language("ku","Kurdish"));
		lmap.put("kv", new Language("kv","Komi"));
		lmap.put("kw", new Language("kw","Cornish"));
		lmap.put("ky", new Language("ky","Kirghiz"));
		lmap.put("la", new Language("la","Latin"));
		lmap.put("lb", new Language("lb","Luxembourgish"));
		lmap.put("lg", new Language("lg","Ganda"));
		lmap.put("li", new Language("li","Limburgish"));
		lmap.put("ln", new Language("ln","Lingala"));
		lmap.put("lo", new Language("lo","Lao"));
		lmap.put("lt", new Language("lt","Lithuanian"));
		lmap.put("lu", new Language("lu","Luba-Katanga"));
		lmap.put("lv", new Language("lv","Latvian"));
		lmap.put("mg", new Language("mg","Malagasy"));
		lmap.put("mh", new Language("mh","Marshallese"));
		lmap.put("mi", new Language("mi","Maori"));
		lmap.put("mk", new Language("mk","Macedonian"));
		lmap.put("ml", new Language("ml","Malayalam"));
		lmap.put("mn", new Language("mn","Mongolian"));
		lmap.put("mo", new Language("mo","Moldavian"));
		lmap.put("mr", new Language("mr","Marathi"));
		lmap.put("ms", new Language("ms","Malay"));
		lmap.put("mt", new Language("mt","Maltese"));
		lmap.put("my", new Language("my","Burmese"));
		lmap.put("na", new Language("na","Nauru"));
		lmap.put("nb", new Language("nb","Norwegian Bokmal"));
		lmap.put("nd", new Language("nd","North Ndebele"));
		lmap.put("ne", new Language("ne","Nepali"));
		lmap.put("ng", new Language("ng","Ndonga"));
		lmap.put("nl", new Language("nl","Dutch"));
		lmap.put("nn", new Language("nn","Norwegian Nynorsk"));
		lmap.put("no", new Language("no","Norwegian"));
		lmap.put("nr", new Language("nr","South Ndebele"));
		lmap.put("nv", new Language("nv","Navajo"));
		lmap.put("ny", new Language("ny","Chichewa"));
		lmap.put("oc", new Language("oc","Occitan"));
		lmap.put("oj", new Language("oj","Ojibwa"));
		lmap.put("om", new Language("om","Oromo"));
		lmap.put("or", new Language("or","Oriya"));
		lmap.put("os", new Language("os","Ossetian"));
		lmap.put("pa", new Language("pa","Panjabi"));
		lmap.put("pi", new Language("pi","Pali"));
		lmap.put("pl", new Language("pl","Polish"));
		lmap.put("ps", new Language("ps","Pashto"));
		lmap.put("pt", new Language("pt","Portuguese"));
		lmap.put("qu", new Language("qu","Quechua"));
		lmap.put("rm", new Language("rm","Raeto-Romance"));
		lmap.put("rn", new Language("rn","Kirundi"));
		lmap.put("ro", new Language("ro","Romanian"));
		lmap.put("ru", new Language("ru","Russian"));
		lmap.put("rw", new Language("rw","Kinyarwanda"));
		lmap.put("sa", new Language("sa","Sanskrit"));
		lmap.put("sc", new Language("sc","Sardinian"));
		lmap.put("sd", new Language("sd","Sindhi"));
		lmap.put("se", new Language("se","Northern Sami"));
		lmap.put("sg", new Language("sg","Sango"));
		lmap.put("sh", new Language("sh","Serbo-Croatian"));
		lmap.put("si", new Language("si","Sinhala"));
		lmap.put("sk", new Language("sk","Slovak"));
		lmap.put("sl", new Language("sl","Slovenian"));
		lmap.put("sm", new Language("sm","Samoan"));
		lmap.put("sn", new Language("sn","Shona"));
		lmap.put("so", new Language("so","Somali"));
		lmap.put("sq", new Language("sq","Albanian"));
		lmap.put("sr", new Language("sr","Serbian"));
		lmap.put("ss", new Language("ss","Swati"));
		lmap.put("st", new Language("st","Sotho"));
		lmap.put("su", new Language("su","Sundanese"));
		lmap.put("sv", new Language("sv","Swedish"));
		lmap.put("sw", new Language("sw","Swahili"));
		lmap.put("ta", new Language("ta","Tamil"));
		lmap.put("te", new Language("te","Telugu"));
		lmap.put("tg", new Language("tg","Tajik"));
		lmap.put("th", new Language("th","Thai"));
		lmap.put("ti", new Language("ti","Tigrinya"));
		lmap.put("tk", new Language("tk","Turkmen"));
		lmap.put("tl", new Language("tl","Tagalog"));
		lmap.put("tn", new Language("tn","Tswana"));
		lmap.put("to", new Language("to","Tonga"));
		lmap.put("tr", new Language("tr","Turkish"));
		lmap.put("ts", new Language("ts","Tsonga"));
		lmap.put("tt", new Language("tt","Tatar"));
		lmap.put("tw", new Language("tw","Twi"));
		lmap.put("ty", new Language("ty","Tahitian"));
		lmap.put("ug", new Language("ug","Uighur"));
		lmap.put("uk", new Language("uk","Ukrainian"));
		lmap.put("ur", new Language("ur","Urdu"));
		lmap.put("uz", new Language("uz","Uzbek"));
		lmap.put("ve", new Language("ve","Venda"));
		lmap.put("vi", new Language("vi","Vietnamese"));
		lmap.put("vo", new Language("vo","Volapuk"));
		lmap.put("wa", new Language("wa","Walloon"));
		lmap.put("wo", new Language("wo","Wolof"));
		lmap.put("xh", new Language("xh","Xhosa"));
		lmap.put("yi", new Language("yi","Yiddish"));
		lmap.put("yo", new Language("yo","Yoruba"));
		lmap.put("za", new Language("za","Zhuang"));
		lmap.put("zh", new Language("zh","Chinese"));
		lmap.put("zu", new Language("zu","Zulu"));
	}
	public static Language languageForISO639_1(String s) {
		Language l = lmap.get(s);
		if (l != null) return l;
		throw new RuntimeException("Unknown language: " + s);
	}
	public boolean equals(Object o) { return this == o; }
	private String lang;
	private String name;
	private Language(String s, String n) {
		lang = s;
		name = n;
	}
	public final String code() {
		return lang;
	}
	public String toString() {
		return name;
	}
	public int hashCode() {
		return lang.hashCode() + 17;
	}
}
