/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.aquaint2;

import edu.umd.cloud9.collection.aquaint2.Aquaint2DocnoMapping;
import edu.umd.cloud9.collection.aquaint2.Aquaint2Document;
import edu.umd.cloud9.collection.aquaint2.Aquaint2DocumentInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class Aquaint2DocnoMappingBuilder
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(Aquaint2DocnoMappingBuilder.class);

    private static int printUsage() {
        System.out.println("usage: [input-path] [output-path] [output-file]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 3) {
            Aquaint2DocnoMappingBuilder.printUsage();
            return -1;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        String outputFile = args[2];
        LOG.info((Object)("Tool: " + Aquaint2DocnoMappingBuilder.class.getCanonicalName()));
        LOG.info((Object)(" - Input path: " + inputPath));
        LOG.info((Object)(" - Output path: " + outputPath));
        LOG.info((Object)(" - Output file: " + outputFile));
        Job job = new Job(this.getConf(), Aquaint2DocnoMappingBuilder.class.getSimpleName());
        job.setJarByClass(Aquaint2DocnoMappingBuilder.class);
        job.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        job.setInputFormatClass(Aquaint2DocumentInputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        FileSystem.get((Configuration)job.getConfiguration()).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        String input = outputPath + (outputPath.endsWith("/") ? "" : "/") + "/part-r-00000";
        Aquaint2DocnoMapping.writeDocnoData(new Path(input), new Path(outputFile), FileSystem.get((Configuration)this.getConf()));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new Aquaint2DocnoMappingBuilder(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private static final IntWritable cnt = new IntWritable(1);

        private MyReducer() {
        }

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)cnt);
            cnt.set(cnt.get() + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends Mapper<LongWritable, Aquaint2Document, Text, IntWritable> {
        private static final Text docid = new Text();
        private static final IntWritable one = new IntWritable(1);

        private MyMapper() {
        }

        public void map(LongWritable key, Aquaint2Document doc, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Count.DOCS).increment(1L);
            docid.set(doc.getDocid());
            context.write((Object)docid, (Object)one);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Count {
        DOCS;

    }
}

