/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.aquaint2;

import edu.umd.cloud9.collection.IndexableFileInputFormat;
import edu.umd.cloud9.collection.XMLInputFormat;
import edu.umd.cloud9.collection.aquaint2.Aquaint2Document;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aquaint2DocumentInputFormat
extends IndexableFileInputFormat<LongWritable, Aquaint2Document> {
    public RecordReader<LongWritable, Aquaint2Document> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new Aquaint2DocumentRecordReader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Aquaint2DocumentRecordReader
    extends RecordReader<LongWritable, Aquaint2Document> {
        private final XMLInputFormat.XMLRecordReader reader = new XMLInputFormat.XMLRecordReader();
        private final Aquaint2Document doc = new Aquaint2Document();

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            conf.set("xmlinput.start", "<DOC ");
            conf.set("xmlinput.end", "</DOC>");
            this.reader.initialize(split, context);
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.reader.getCurrentKey();
        }

        public Aquaint2Document getCurrentValue() throws IOException, InterruptedException {
            Aquaint2Document.readDocument(this.doc, this.reader.getCurrentValue().toString());
            return this.doc;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.reader.nextKeyValue();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.reader.getProgress();
        }
    }
}

