/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.aquaint2;

import edu.umd.cloud9.collection.IndexableFileInputFormatOld;
import edu.umd.cloud9.collection.XMLInputFormatOld;
import edu.umd.cloud9.collection.aquaint2.Aquaint2Document;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aquaint2DocumentInputFormatOld
extends IndexableFileInputFormatOld<LongWritable, Aquaint2Document> {
    public void configure(JobConf conf) {
    }

    public RecordReader<LongWritable, Aquaint2Document> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        return new Aquaint2DocumentRecordReader((FileSplit)inputSplit, conf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Aquaint2DocumentRecordReader
    implements RecordReader<LongWritable, Aquaint2Document> {
        private final XMLInputFormatOld.XMLRecordReader reader;
        private final Text text = new Text();
        private final LongWritable offset = new LongWritable();

        public Aquaint2DocumentRecordReader(FileSplit split, JobConf conf) throws IOException {
            conf.set("xmlinput.start", "<DOC ");
            conf.set("xmlinput.end", "</DOC>");
            this.reader = new XMLInputFormatOld.XMLRecordReader(split, conf);
        }

        public boolean next(LongWritable key, Aquaint2Document value) throws IOException {
            if (!this.reader.next(this.offset, this.text)) {
                return false;
            }
            key.set(this.offset.get());
            Aquaint2Document.readDocument(value, this.text.toString());
            return true;
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public Aquaint2Document createValue() {
            return new Aquaint2Document();
        }

        public long getPos() throws IOException {
            return this.reader.getPos();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return (float)(this.reader.getPos() - this.reader.getStart()) / (float)(this.reader.getEnd() - this.reader.getStart());
        }
    }
}

