/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.aquaint2;

import edu.umd.cloud9.collection.DocumentForwardIndex;
import edu.umd.cloud9.collection.aquaint2.Aquaint2DocnoMapping;
import edu.umd.cloud9.collection.aquaint2.Aquaint2Document;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aquaint2ForwardIndex
implements DocumentForwardIndex<Aquaint2Document> {
    private static final Logger LOG = Logger.getLogger(Aquaint2ForwardIndex.class);
    private long[] offsets;
    private int[] lengths;
    private FSDataInputStream input;
    private Aquaint2DocnoMapping docnoMapping = new Aquaint2DocnoMapping();
    private String collectionPath;

    @Override
    public int getDocno(String docid) {
        return this.docnoMapping.getDocno(docid);
    }

    @Override
    public String getDocid(int docno) {
        return this.docnoMapping.getDocid(docno);
    }

    @Override
    public int getLastDocno() {
        return this.offsets.length - 1;
    }

    @Override
    public int getFirstDocno() {
        return 1;
    }

    @Override
    public String getCollectionPath() {
        return this.collectionPath;
    }

    @Override
    public Aquaint2Document getDocument(String docid) {
        return this.getDocument(this.docnoMapping.getDocno(docid));
    }

    @Override
    public Aquaint2Document getDocument(int docno) {
        Aquaint2Document doc = new Aquaint2Document();
        try {
            LOG.debug((Object)("docno " + docno + ": byte offset " + this.offsets[docno] + ", length " + this.lengths[docno]));
            this.input.seek(this.offsets[docno]);
            byte[] arr = new byte[this.lengths[docno]];
            this.input.read(arr);
            Aquaint2Document.readDocument(doc, new String(arr));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    @Override
    public void loadIndex(Path index, Path mapping, FileSystem fs) throws IOException {
        FSDataInputStream in = fs.open(index);
        in.readUTF();
        this.collectionPath = in.readUTF();
        int sz = in.readInt() + 1;
        this.offsets = new long[sz];
        this.lengths = new int[sz];
        for (int i = 1; i < sz; ++i) {
            this.offsets[i] = in.readLong();
            this.lengths[i] = in.readInt();
        }
        in.close();
        this.input = fs.open(new Path(this.collectionPath));
        this.docnoMapping.loadMapping(mapping, fs);
    }
}

