/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.aquaint2;

import edu.umd.cloud9.collection.aquaint2.Aquaint2Document;
import edu.umd.cloud9.collection.aquaint2.Aquaint2DocumentInputFormatOld;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DemoCountAquaint2Documents
extends Configured
implements Tool {
    private static int printUsage() {
        System.out.println("usage: [input] [output-dir] [mappings-file] [num-mappers]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 4) {
            DemoCountAquaint2Documents.printUsage();
            return -1;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        String mappingFile = args[2];
        int mapTasks = Integer.parseInt(args[3]);
        System.out.println("input dir: " + inputPath);
        System.out.println("output dir: " + outputPath);
        System.out.println("mapping file: " + mappingFile);
        System.out.println("number of mappers: " + mapTasks);
        JobConf conf = new JobConf(DemoCountAquaint2Documents.class);
        conf.setJobName("DemoCountAquaint2Documents");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setInputFormat(Aquaint2DocumentInputFormatOld.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(MyMapper.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        JobClient.runJob((JobConf)conf);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Aquaint2Document, LongWritable, Text> {
        private MyMapper() {
        }

        public void map(LongWritable key, Aquaint2Document doc, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
            reporter.incrCounter((Enum)Count.DOCS, 1L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Count {
        DOCS;

    }
}

