/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.clue;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.clue.ClueWarcDocnoMappingBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import tl.lin.data.map.HMapKI;
import tl.lin.data.map.MapKI;

public class ClueWarcDocnoMapping
implements DocnoMapping {
    private static final int[] offets = new int[13217];
    private static final HMapKI<String> subdirMapping = new HMapKI();
    private static final NumberFormat FormatW2 = new DecimalFormat("00");
    private static final NumberFormat FormatW5 = new DecimalFormat("00000");

    public int getDocno(String docid) {
        if (docid == null) {
            return -1;
        }
        String sec = docid.substring(10, 16);
        int secStart = subdirMapping.get((Comparable)((Object)sec));
        int file = Integer.parseInt(docid.substring(17, 19));
        int cnt = Integer.parseInt(docid.substring(20, 25));
        int idx = secStart + file;
        int docno = offets[idx] + cnt;
        return docno;
    }

    public String getDocid(int docno) {
        int i = 0;
        for (i = 0; i < offets.length && docno >= offets[i]; ++i) {
        }
        --i;
        String docid = null;
        for (MapKI.Entry e : subdirMapping.getEntriesSortedByValue()) {
            if (e.getValue() > i) continue;
            docid = "clueweb09-" + (String)e.getKey() + "-" + FormatW2.format(i - e.getValue()) + "-" + FormatW5.format(docno - offets[i]);
            break;
        }
        return docid;
    }

    public void loadMapping(Path p, FileSystem fs) throws IOException {
        LineReader reader = new LineReader((InputStream)fs.open(p));
        Text t = new Text();
        int cnt = 0;
        String prevSec = null;
        while (reader.readLine(t) > 0) {
            String[] arr = t.toString().split(",");
            if (prevSec == null || !arr[0].equals(prevSec)) {
                subdirMapping.put((Comparable)((Object)arr[0]), cnt);
            }
            ClueWarcDocnoMapping.offets[cnt] = Integer.parseInt(arr[3]);
            prevSec = arr[0];
            ++cnt;
        }
        reader.close();
    }

    public DocnoMapping.Builder getBuilder() {
        return new ClueWarcDocnoMappingBuilder();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("usage: (getDocno|getDocid) [mapping-file] [docid/docno]");
            System.exit(-1);
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        System.out.println("loading mapping file " + args[1]);
        ClueWarcDocnoMapping mapping = new ClueWarcDocnoMapping();
        mapping.loadMapping(new Path(args[1]), fs);
        if (args[0].equals("getDocno")) {
            System.out.println("looking up docno for \"" + args[2] + "\"");
            int idx = mapping.getDocno(args[2]);
            if (idx > 0) {
                System.out.println(mapping.getDocno(args[2]));
            } else {
                System.err.print("Invalid docid!");
            }
        } else if (args[0].equals("getDocid")) {
            try {
                System.out.println("looking up docid for " + args[2]);
                System.out.println(mapping.getDocid(Integer.parseInt(args[2])));
            }
            catch (Exception e) {
                System.err.print("Invalid docno!");
            }
        } else {
            System.out.println("Invalid command!");
            System.out.println("usage: (list|getDocno|getDocid) [mappings-file] [docid/docno]");
        }
    }
}

