/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.clue;

import edu.umd.cloud9.collection.clue.ClueWarcForwardIndex;
import edu.umd.cloud9.collection.clue.ClueWarcRecord;
import edu.umd.cloud9.mapred.NoSplitSequenceFileInputFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class ClueWarcForwardIndexBuilder
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(ClueWarcForwardIndexBuilder.class);
    public static final String COLLECTION_OPTION = "collection";
    public static final String INDEX_OPTION = "index";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) collection path (must be block-compressed SequenceFiles)");
        options.addOption(OptionBuilder.create((String)COLLECTION_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) output index path");
        options.addOption(OptionBuilder.create((String)INDEX_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(COLLECTION_OPTION) || !cmdline.hasOption(INDEX_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        JobConf conf = new JobConf(this.getConf(), ClueWarcForwardIndexBuilder.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        String collectionPath = cmdline.getOptionValue(COLLECTION_OPTION);
        String indexFile = cmdline.getOptionValue(INDEX_OPTION);
        LOG.info((Object)("Tool name: " + ClueWarcForwardIndexBuilder.class.getSimpleName()));
        LOG.info((Object)(" - collection path: " + collectionPath));
        LOG.info((Object)(" - index file: " + indexFile));
        LOG.info((Object)"Note: This tool only works on block-compressed SequenceFiles!");
        Random random = new Random();
        Path outputPath = new Path("tmp-" + ClueWarcForwardIndexBuilder.class.getSimpleName() + "-" + random.nextInt(10000));
        conf.setJobName(ClueWarcForwardIndexBuilder.class.getSimpleName() + ":" + collectionPath);
        conf.setNumMapTasks(100);
        conf.setNumReduceTasks(1);
        for (FileStatus status : fs.listStatus(new Path(collectionPath))) {
            FileInputFormat.addInputPath((JobConf)conf, (Path)status.getPath());
        }
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath);
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setInputFormat(NoSplitSequenceFileInputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapRunnerClass(MyMapRunner.class);
        conf.setReducerClass(IdentityReducer.class);
        fs.delete(outputPath, true);
        RunningJob job = JobClient.runJob((JobConf)conf);
        Counters counters = job.getCounters();
        int blocks = (int)((Counters.Counter)counters.findCounter((Enum)Blocks.Total)).getCounter();
        LOG.info((Object)("number of blocks: " + blocks));
        LOG.info((Object)"Writing index file...");
        LineReader reader = new LineReader((InputStream)fs.open(new Path(outputPath + "/part-00000")));
        FSDataOutputStream out = fs.create(new Path(indexFile), true);
        out.writeUTF(ClueWarcForwardIndex.class.getCanonicalName());
        out.writeUTF(collectionPath);
        out.writeInt(blocks);
        int cnt = 0;
        Text line = new Text();
        while (reader.readLine(line) > 0) {
            String[] arr = line.toString().split("\\s+");
            int docno = Integer.parseInt(arr[0]);
            int offset = Integer.parseInt(arr[1]);
            short fileno = Short.parseShort(arr[2]);
            out.writeInt(docno);
            out.writeInt(offset);
            out.writeShort((int)fileno);
            if (++cnt % 100000 != 0) continue;
            LOG.info((Object)(cnt + " blocks written"));
        }
        reader.close();
        out.close();
        if (cnt != blocks) {
            throw new RuntimeException("Error: mismatch in block count!");
        }
        fs.delete(outputPath, true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("Running " + ClueWarcForwardIndexBuilder.class.getCanonicalName() + " with args " + Arrays.toString(args)));
        ToolRunner.run((Tool)new ClueWarcForwardIndexBuilder(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapRunner
    implements MapRunnable<IntWritable, ClueWarcRecord, IntWritable, Text> {
        private static final IntWritable KEY = new IntWritable();
        private static final Text VALUE = new Text();
        private int fileno;

        private MyMapRunner() {
        }

        public void configure(JobConf job) {
            String file = job.get("map.input.file");
            this.fileno = Integer.parseInt(file.substring(file.indexOf("part-") + 5));
        }

        public void run(RecordReader<IntWritable, ClueWarcRecord> input, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            IntWritable key = new IntWritable();
            ClueWarcRecord value = new ClueWarcRecord();
            long pos = -1L;
            long prevPos = -1L;
            int prevDocno = 0;
            pos = input.getPos();
            while (input.next((Object)key, (Object)value)) {
                if (prevPos != -1L && prevPos != pos) {
                    LOG.info((Object)("- beginning of block at " + prevPos + ", docno:" + prevDocno + ", file:" + this.fileno));
                    KEY.set(prevDocno);
                    VALUE.set(prevPos + "\t" + this.fileno);
                    output.collect((Object)KEY, (Object)VALUE);
                    reporter.incrCounter((Enum)Blocks.Total, 1L);
                }
                prevPos = pos;
                pos = input.getPos();
                prevDocno = key.get();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Blocks {
        Total;

    }
}

