/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.clue;

import edu.umd.cloud9.collection.clue.ClueWarcRecord;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClueWarcInputFormat
extends FileInputFormat<LongWritable, ClueWarcRecord> {
    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }

    public RecordReader<LongWritable, ClueWarcRecord> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        return new ClueWarcRecordReader((Configuration)conf, (FileSplit)split);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClueWarcRecordReader
    implements RecordReader<LongWritable, ClueWarcRecord> {
        private long recordCount = 1L;
        private Path path = null;
        private DataInputStream input = null;
        private long totalNumBytesRead = 0L;

        public ClueWarcRecordReader(Configuration conf, FileSplit split) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)conf);
            this.path = split.getPath();
            CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
            CompressionCodec compressionCodec = compressionCodecs.getCodec(this.path);
            this.input = new DataInputStream((InputStream)compressionCodec.createInputStream((InputStream)fs.open(this.path)));
        }

        public boolean next(LongWritable key, ClueWarcRecord value) throws IOException {
            DataInputStream whichStream = this.input;
            ClueWarcRecord newRecord = ClueWarcRecord.readNextWarcRecord(whichStream);
            if (newRecord == null) {
                return false;
            }
            this.totalNumBytesRead += (long)newRecord.getTotalRecordLength();
            newRecord.setWarcFilePath(this.path.toString());
            value.set(newRecord);
            key.set(this.recordCount);
            ++this.recordCount;
            return true;
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public ClueWarcRecord createValue() {
            return new ClueWarcRecord();
        }

        public long getPos() throws IOException {
            return this.totalNumBytesRead;
        }

        public void close() throws IOException {
            this.input.close();
        }

        public float getProgress() throws IOException {
            return (float)this.recordCount / 40000.0f;
        }
    }
}

