/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.clue;

import com.google.common.collect.Lists;
import edu.umd.cloud9.collection.clue.ClueWarcRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class ScanBlockCompressedSequenceFile {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("usage: [SequenceFile]");
            System.exit(-1);
        }
        ArrayList seekPoints = Lists.newArrayList();
        long pos = -1L;
        long prevPos = -1L;
        int prevDocno = 0;
        Path path = new Path(args[0]);
        Configuration config = new Configuration();
        SequenceFile.Reader reader = new SequenceFile.Reader(config, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
        IntWritable key = new IntWritable();
        ClueWarcRecord value = new ClueWarcRecord();
        pos = reader.getPosition();
        int cnt = 0;
        while (reader.next((Writable)key, (Writable)value)) {
            if (prevPos != -1L && prevPos != pos) {
                System.out.println("## beginning of block at " + prevPos + ", docno:" + prevDocno);
                seekPoints.add(prevPos);
            }
            System.out.println("offset:" + pos + "\tdocno:" + key + "\tdocid:" + value.getDocid());
            prevPos = pos;
            pos = reader.getPosition();
            prevDocno = key.get();
            if (++cnt <= Integer.MAX_VALUE) continue;
        }
        reader.close();
        reader = new SequenceFile.Reader(config, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
        Iterator i$ = seekPoints.iterator();
        while (i$.hasNext()) {
            long p = (Long)i$.next();
            reader.seek(p);
            reader.next((Writable)key, (Writable)value);
            System.out.println("seeking to pos " + p + "\tdocno:" + key + "\tdocid:" + value.getDocid());
        }
        reader.close();
    }
}

