/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.line;

import edu.umd.cloud9.collection.line.TextDocnoMapping;
import edu.umd.cloud9.collection.line.TextDocument;
import edu.umd.cloud9.collection.line.TextDocumentInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class NumberTextDocuments
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(NumberTextDocuments.class);

    private static int printUsage() {
        System.out.println("usage: [input-path] [output-path] [output-file] [num-mappers]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 4) {
            NumberTextDocuments.printUsage();
            return -1;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        String outputFile = args[2];
        int mapTasks = Integer.parseInt(args[3]);
        sLogger.info((Object)"Tool: NumberTextDocuments");
        sLogger.info((Object)(" - Input path: " + inputPath));
        sLogger.info((Object)(" - Output path: " + outputPath));
        sLogger.info((Object)(" - Output file: " + outputFile));
        sLogger.info((Object)("Launching with " + mapTasks + " mappers..."));
        JobConf conf = new JobConf(this.getConf(), NumberTextDocuments.class);
        conf.setJobName("NumberTextDocuments");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setInputFormat(TextDocumentInputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setMapperClass(MyMapper.class);
        conf.setReducerClass(MyReducer.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        JobClient.runJob((JobConf)conf);
        String input = outputPath + (outputPath.endsWith("/") ? "" : "/") + "/part-00000";
        TextDocnoMapping.writeDocnoData(input, outputFile, FileSystem.get((Configuration)this.getConf()));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new NumberTextDocuments(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer
    extends MapReduceBase
    implements Reducer<Text, IntWritable, Text, IntWritable> {
        private static final IntWritable sCnt = new IntWritable(1);

        private MyReducer() {
        }

        public void reduce(Text key, Iterator<IntWritable> values, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            output.collect((Object)key, (Object)sCnt);
            sCnt.set(sCnt.get() + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, TextDocument, Text, IntWritable> {
        private static final Text sText = new Text();
        private static final IntWritable sInt = new IntWritable(1);

        private MyMapper() {
        }

        public void map(LongWritable key, TextDocument doc, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            reporter.incrCounter((Enum)Count.DOCS, 1L);
            sText.set(doc.getDocid());
            output.collect((Object)sText, (Object)sInt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Count {
        DOCS;

    }
}

