/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.line;

import edu.umd.cloud9.collection.DocnoMapping;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.apache.log4j.Logger;

public class TextDocnoMapping
implements DocnoMapping {
    private static final Logger sLogger = Logger.getLogger(TextDocnoMapping.class);
    private String[] mDocids;

    public int getDocno(String docid) {
        return Arrays.binarySearch(this.mDocids, docid);
    }

    public String getDocid(int docno) {
        return this.mDocids[docno];
    }

    public void loadMapping(Path p, FileSystem fs) throws IOException {
        this.mDocids = TextDocnoMapping.readDocnoData(p, fs);
    }

    public static void writeDocnoData(String inputFile, String outputFile, FileSystem fs) throws IOException {
        sLogger.info((Object)("Writing docno data to " + outputFile));
        LineReader reader = new LineReader((InputStream)fs.open(new Path(inputFile)));
        ArrayList<String> list = new ArrayList<String>();
        sLogger.info((Object)("Reading " + inputFile));
        int cnt = 0;
        Text line = new Text();
        while (reader.readLine(line) > 0) {
            String[] arr = line.toString().split("\\t");
            list.add(arr[0]);
            if (++cnt % 100000 != 0) continue;
            sLogger.info((Object)(cnt + " docs"));
        }
        reader.close();
        sLogger.info((Object)(cnt + " docs total. Done!"));
        cnt = 0;
        sLogger.info((Object)("Writing " + outputFile));
        FSDataOutputStream out = fs.create(new Path(outputFile), true);
        out.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            out.writeUTF((String)list.get(i));
            if (++cnt % 100000 != 0) continue;
            sLogger.info((Object)(cnt + " docs"));
        }
        out.close();
        sLogger.info((Object)(cnt + " docs total. Done!"));
    }

    public static String[] readDocnoData(Path p, FileSystem fs) throws IOException {
        FSDataInputStream in = fs.open(p);
        int sz = in.readInt() + 1;
        String[] arr = new String[sz];
        for (int i = 1; i < sz; ++i) {
            arr[i] = in.readUTF();
        }
        in.close();
        arr[0] = "";
        return arr;
    }

    public DocnoMapping.Builder getBuilder() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("usage: (list|getDocno|getDocid) [mapping-file] [docid/docno]");
            System.exit(-1);
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        System.out.println("loading mapping file " + args[1]);
        TextDocnoMapping mapping = new TextDocnoMapping();
        mapping.loadMapping(new Path(args[1]), fs);
        if (args[0].equals("list")) {
            for (int i = 1; i < mapping.mDocids.length; ++i) {
                System.out.println(i + "\t" + mapping.mDocids[i]);
            }
        } else if (args[0].equals("getDocno")) {
            System.out.println("looking up docno for \"" + args[2] + "\"");
            int idx = mapping.getDocno(args[2]);
            if (idx > 0) {
                System.out.println(mapping.getDocno(args[2]));
            } else {
                System.err.print("Invalid docid!");
            }
        } else if (args[0].equals("getDocid")) {
            try {
                System.out.println("looking up docid for " + args[2]);
                System.out.println(mapping.getDocid(Integer.parseInt(args[2])));
            }
            catch (Exception e) {
                System.err.print("Invalid docno!");
            }
        } else {
            System.out.println("Invalid command!");
            System.out.println("usage: (list|getDocno|getDocid) [mappings-file] [docid/docno]");
        }
    }
}

