/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.line;

import edu.umd.cloud9.collection.Indexable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;

public class TextDocument
extends Indexable {
    private String mContents;
    private String mDocid;

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.mDocid);
        byte[] bytes = this.mContents.getBytes();
        WritableUtils.writeVInt((DataOutput)out, (int)bytes.length);
        out.write(bytes, 0, bytes.length);
    }

    public void readFields(DataInput in) throws IOException {
        this.mDocid = in.readUTF();
        int length = WritableUtils.readVInt((DataInput)in);
        byte[] bytes = new byte[length];
        in.readFully(bytes, 0, length);
        this.mContents = new String(bytes);
    }

    public String getDocid() {
        return this.mDocid;
    }

    public void setDocid(String docid) {
        this.mDocid = docid;
    }

    public String getContent() {
        return this.mContents;
    }

    public void setContent(String contents) {
        this.mContents = contents;
    }

    public static void readDocument(TextDocument doc, String s) {
        if (s == null) {
            throw new RuntimeException("Error, can't read null string!");
        }
        String[] arr = s.split("\\t");
        doc.mContents = arr[1];
        doc.mDocid = arr[0];
    }
}

