/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.line;

import edu.umd.cloud9.collection.line.TextDocument;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocumentInputFormat
extends FileInputFormat<LongWritable, TextDocument>
implements JobConfigurable {
    private CompressionCodecFactory compressionCodecs = null;

    public void configure(JobConf conf) {
        this.compressionCodecs = new CompressionCodecFactory((Configuration)conf);
    }

    protected boolean isSplitable(FileSystem fs, Path file) {
        return this.compressionCodecs.getCodec(file) == null;
    }

    public RecordReader<LongWritable, TextDocument> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        return new TextDocumentLineRecordReader((Configuration)job, (FileSplit)genericSplit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextDocumentLineRecordReader
    implements RecordReader<LongWritable, TextDocument> {
        private LineRecordReader mRecordReader;
        private Text mText;

        public TextDocumentLineRecordReader(Configuration job, FileSplit split) throws IOException {
            this.mRecordReader = new LineRecordReader(job, split);
            this.mText = new Text();
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public TextDocument createValue() {
            return new TextDocument();
        }

        public synchronized long getPos() throws IOException {
            return this.mRecordReader.getPos();
        }

        public synchronized void close() throws IOException {
            this.mRecordReader.getPos();
        }

        public float getProgress() {
            try {
                return this.mRecordReader.getProgress();
            }
            catch (IOException e) {
                return 0.0f;
            }
        }

        public synchronized boolean next(LongWritable key, TextDocument value) {
            boolean b;
            try {
                b = this.mRecordReader.next(key, this.mText);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            if (b) {
                TextDocument.readDocument(value, this.mText.toString());
            }
            return b;
        }
    }
}

