/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.medline;

import com.google.common.base.Preconditions;
import edu.umd.cloud9.collection.Indexable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;

public class MedlineCitation
extends Indexable {
    public static final String XML_START_TAG = "<MedlineCitation";
    public static final String XML_END_TAG = "</MedlineCitation>";
    private String pmid;
    private String citation;
    private String title;
    private String abstractText;

    public void write(DataOutput out) throws IOException {
        byte[] bytes = this.citation.getBytes();
        WritableUtils.writeVInt((DataOutput)out, (int)bytes.length);
        out.write(bytes, 0, bytes.length);
    }

    public void readFields(DataInput in) throws IOException {
        int length = WritableUtils.readVInt((DataInput)in);
        byte[] bytes = new byte[length];
        in.readFully(bytes, 0, length);
        MedlineCitation.readCitation(this, new String(bytes));
    }

    public String getDocid() {
        return this.getPmid();
    }

    public String getContent() {
        return this.getTitle() + "\n\n" + this.getAbstract();
    }

    public String getPmid() {
        if (this.pmid == null) {
            int start = this.citation.indexOf("<PMID>");
            if (start == -1) {
                throw new RuntimeException(this.getRawXML());
            }
            int end = this.citation.indexOf("</PMID>", start);
            this.pmid = this.citation.substring(start + 6, end);
        }
        return this.pmid;
    }

    public String getTitle() {
        if (this.title == null) {
            int start = this.citation.indexOf("<ArticleTitle>");
            if (start == -1) {
                this.title = "";
            } else {
                int end = this.citation.indexOf("</ArticleTitle>", start);
                this.title = this.citation.substring(start + 14, end);
            }
        }
        return this.title;
    }

    public String getAbstract() {
        if (this.abstractText == null) {
            int start = this.citation.indexOf("<AbstractText>");
            if (start == -1) {
                this.abstractText = "";
            } else {
                int end = this.citation.indexOf("</AbstractText>", start);
                this.abstractText = this.citation.substring(start + 14, end);
            }
        }
        return this.abstractText;
    }

    public String getRawXML() {
        return this.citation;
    }

    public static void readCitation(MedlineCitation citation, String s) {
        Preconditions.checkNotNull((Object)citation);
        Preconditions.checkNotNull((Object)s);
        citation.citation = s;
        citation.pmid = null;
        citation.title = null;
        citation.abstractText = null;
    }
}

