/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.medline;

import edu.umd.cloud9.collection.IndexableFileInputFormat;
import edu.umd.cloud9.collection.XMLInputFormat;
import edu.umd.cloud9.collection.medline.MedlineCitation;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedlineCitationInputFormat
extends IndexableFileInputFormat<LongWritable, MedlineCitation> {
    public RecordReader<LongWritable, MedlineCitation> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new MedlineCitationRecordReader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MedlineCitationRecordReader
    extends RecordReader<LongWritable, MedlineCitation> {
        private final XMLInputFormat.XMLRecordReader reader = new XMLInputFormat.XMLRecordReader();
        private final MedlineCitation doc = new MedlineCitation();

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            conf.set("xmlinput.start", "<MedlineCitation");
            conf.set("xmlinput.end", "</MedlineCitation>");
            this.reader.initialize(split, context);
        }

        public LongWritable getCurrentKey() throws IOException, InterruptedException {
            return this.reader.getCurrentKey();
        }

        public MedlineCitation getCurrentValue() throws IOException, InterruptedException {
            MedlineCitation.readCitation(this.doc, this.reader.getCurrentValue().toString());
            return this.doc;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.reader.nextKeyValue();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.reader.getProgress();
        }
    }
}

