/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.medline;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.medline.MedlineCitation;
import edu.umd.cloud9.collection.medline.MedlineCitationInputFormat;
import edu.umd.cloud9.collection.medline.MedlineDocnoMapping;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class MedlineDocnoMappingBuilder
extends Configured
implements Tool,
DocnoMapping.Builder {
    private static final Logger LOG = Logger.getLogger(MedlineDocnoMappingBuilder.class);
    private static final Random random = new Random();

    public int build(Path src, Path dest, Configuration conf) throws IOException {
        super.setConf(conf);
        return this.run(new String[]{"-collection=" + src.toString(), "-docnoMapping=" + dest.toString()});
    }

    public int run(String[] args) throws IOException {
        DocnoMapping.DefaultBuilderOptions options = DocnoMapping.BuilderUtils.parseDefaultOptions(args);
        if (options == null) {
            return -1;
        }
        String tmpDir = "tmp-" + MedlineDocnoMappingBuilder.class.getSimpleName() + "-" + random.nextInt(10000);
        LOG.info((Object)("Tool: " + MedlineDocnoMappingBuilder.class.getCanonicalName()));
        LOG.info((Object)(" - input path: " + options.collection));
        LOG.info((Object)(" - output file: " + options.docnoMapping));
        Job job = new Job(this.getConf(), MedlineDocnoMappingBuilder.class.getSimpleName() + ":" + options.collection);
        FileSystem fs = FileSystem.get((Configuration)job.getConfiguration());
        job.setJarByClass(MedlineDocnoMappingBuilder.class);
        job.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(options.collection)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(tmpDir));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        job.setInputFormatClass(MedlineCitationInputFormat.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(IntWritable.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        fs.delete(new Path(tmpDir), true);
        try {
            job.waitForCompletion(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String input = tmpDir + (tmpDir.endsWith("/") ? "" : "/") + "/part-r-00000";
        MedlineDocnoMapping.writeMappingData(new Path(input), new Path(options.docnoMapping), FileSystem.get((Configuration)this.getConf()));
        fs.delete(new Path(tmpDir), true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new MedlineDocnoMappingBuilder(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer
    extends Reducer<IntWritable, IntWritable, IntWritable, IntWritable> {
        private static final IntWritable cnt = new IntWritable(1);

        private MyReducer() {
        }

        public void reduce(IntWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)cnt);
            cnt.set(cnt.get() + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends Mapper<LongWritable, MedlineCitation, IntWritable, IntWritable> {
        private static final IntWritable docid = new IntWritable();
        private static final IntWritable one = new IntWritable(1);

        private MyMapper() {
        }

        public void map(LongWritable key, MedlineCitation doc, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Count.DOCS).increment(1L);
            docid.set(Integer.parseInt(doc.getDocid()));
            context.write((Object)docid, (Object)one);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Count {
        DOCS;

    }
}

