/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trec;

import edu.umd.cloud9.collection.DocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocnoMapping;
import edu.umd.cloud9.collection.trec.TrecDocument;
import edu.umd.cloud9.collection.trec.TrecDocumentInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class CountTrecDocuments
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(CountTrecDocuments.class);
    public static final String COLLECTION_OPTION = "collection";
    public static final String OUTPUT_OPTION = "output";
    public static final String MAPPING_OPTION = "docnoMapping";
    public static final String COUNT_OPTION = "countOutput";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) collection path");
        options.addOption(OptionBuilder.create((String)COLLECTION_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) output path");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) DocnoMapping data");
        options.addOption(OptionBuilder.create((String)MAPPING_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(optional) output file to write the number of records");
        options.addOption(OptionBuilder.create((String)COUNT_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(COLLECTION_OPTION) && cmdline.hasOption(OUTPUT_OPTION) && cmdline.hasOption(MAPPING_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(COLLECTION_OPTION);
        String outputPath = cmdline.getOptionValue(OUTPUT_OPTION);
        String mappingFile = cmdline.getOptionValue(MAPPING_OPTION);
        LOG.info((Object)("Tool: " + CountTrecDocuments.class.getSimpleName()));
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output dir: " + outputPath));
        LOG.info((Object)(" - docno mapping file: " + mappingFile));
        Job job = new Job(this.getConf(), CountTrecDocuments.class.getSimpleName());
        job.setJarByClass(CountTrecDocuments.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().set("DocnoMappingClass", TrecDocnoMapping.class.getCanonicalName());
        DistributedCache.addCacheFile((URI)new URI(mappingFile), (Configuration)job.getConfiguration());
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        job.setInputFormatClass(TrecDocumentInputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(MyMapper.class);
        FileSystem.get((Configuration)job.getConfiguration()).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        Counters counters = job.getCounters();
        int numDocs = (int)counters.findCounter((Enum)Count.DOCS).getValue();
        LOG.info((Object)("Read " + numDocs + " docs."));
        if (cmdline.hasOption(COUNT_OPTION)) {
            String f = cmdline.getOptionValue(COUNT_OPTION);
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            FSDataOutputStream out = fs.create(new Path(f));
            out.write(new Integer(numDocs).toString().getBytes());
            out.close();
        }
        return numDocs;
    }

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("Running " + CountTrecDocuments.class.getCanonicalName() + " with args " + Arrays.toString(args)));
        ToolRunner.run((Tool)new CountTrecDocuments(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends Mapper<LongWritable, TrecDocument, Text, IntWritable> {
        private static final Text docid = new Text();
        private static final IntWritable one = new IntWritable(1);
        private DocnoMapping docMapping;

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            try {
                Configuration conf = context.getConfiguration();
                Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
                this.docMapping = (DocnoMapping)Class.forName(conf.get("DocnoMappingClass")).newInstance();
                this.docMapping.loadMapping(localFiles[0], (FileSystem)FileSystem.getLocal((Configuration)conf));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error initializing DocnoMapping!");
            }
        }

        public void map(LongWritable key, TrecDocument doc, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Count.DOCS).increment(1L);
            docid.set(doc.getDocid());
            one.set(this.docMapping.getDocno(doc.getDocid()));
            context.write((Object)docid, (Object)one);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Count {
        DOCS;

    }
}

