/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.trecweb;

import edu.umd.cloud9.collection.trecweb.TrecWebDocument;
import edu.umd.cloud9.collection.trecweb.TrecWebDocumentInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class RepackTrecWebCollection
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(RepackTrecWebCollection.class);
    public static final String COLLECTION_OPTION = "collection";
    public static final String OUTPUT_OPTION = "output";
    public static final String COMPRESSION_OPTION = "compressionType";

    private RepackTrecWebCollection() {
    }

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) collection path");
        options.addOption(OptionBuilder.create((String)COLLECTION_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) output path");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"(required) compression type: 'block', 'record', or 'none'");
        options.addOption(OptionBuilder.create((String)COMPRESSION_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(COLLECTION_OPTION) && cmdline.hasOption(OUTPUT_OPTION) && cmdline.hasOption(COMPRESSION_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String collection = cmdline.getOptionValue(COLLECTION_OPTION);
        String output = cmdline.getOptionValue(OUTPUT_OPTION);
        String compressionType = cmdline.getOptionValue(COMPRESSION_OPTION);
        if (!(compressionType.equals("block") || compressionType.equals("record") || compressionType.equals("none"))) {
            System.err.println("Error: \"" + compressionType + "\" unknown compression type!");
            System.exit(-1);
        }
        int blocksize = 1000000;
        Job job = new Job(this.getConf(), RepackTrecWebCollection.class.getSimpleName() + ":" + collection);
        FileSystem fs = FileSystem.get((Configuration)job.getConfiguration());
        job.setJarByClass(RepackTrecWebCollection.class);
        LOG.info((Object)("Tool name: " + RepackTrecWebCollection.class.getCanonicalName()));
        LOG.info((Object)(" - collection path: " + collection));
        LOG.info((Object)(" - output path: " + output));
        LOG.info((Object)(" - compression type: " + compressionType));
        if (compressionType.equals("block")) {
            LOG.info((Object)(" - block size: " + blocksize));
        }
        Path collectionPath = new Path(collection);
        for (FileStatus status : fs.listStatus(collectionPath)) {
            if (status.isDirectory()) {
                for (FileStatus s : fs.listStatus(status.getPath())) {
                    FileInputFormat.addInputPath((Job)job, (Path)s.getPath());
                }
                continue;
            }
            FileInputFormat.addInputPath((Job)job, (Path)status.getPath());
        }
        int numReducers = 100;
        if (collection.toLowerCase().contains("wt10g")) {
            numReducers = 50;
        } else if (collection.toLowerCase().contains("gov2")) {
            numReducers = 200;
        }
        LOG.info((Object)(" - number of reducers: " + numReducers));
        job.setNumReduceTasks(numReducers);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        if (compressionType.equals("none")) {
            SequenceFileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        } else {
            SequenceFileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            if (compressionType.equals("record")) {
                SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD);
            } else {
                SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
                job.getConfiguration().setInt("io.seqfile.compress.blocksize", blocksize);
            }
        }
        job.setInputFormatClass(TrecWebDocumentInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(TrecWebDocument.class);
        job.setMapperClass(MyMapper.class);
        fs.delete(new Path(output), true);
        try {
            job.waitForCompletion(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("Running " + RepackTrecWebCollection.class.getCanonicalName() + " with args " + Arrays.toString(args)));
        ToolRunner.run((Configuration)new Configuration(), (Tool)new RepackTrecWebCollection(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends Mapper<LongWritable, TrecWebDocument, LongWritable, TrecWebDocument> {
        private MyMapper() {
        }

        public void map(LongWritable key, TrecWebDocument doc, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Documents.Count).increment(1L);
            context.write((Object)key, (Object)doc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Documents {
        Count;

    }
}

