/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import edu.umd.cloud9.collection.wikipedia.WikipediaPageInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class CountWikipediaPages
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(CountWikipediaPages.class);
    private static final String INPUT_OPTION = "input";
    private static final String LANGUAGE_OPTION = "wiki_language";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"XML dump file");
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"en|sv|de|cs|es|zh|ar|tr");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"two-letter language code");
        options.addOption(OptionBuilder.create((String)LANGUAGE_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String language = "en";
        if (cmdline.hasOption(LANGUAGE_OPTION) && (language = cmdline.getOptionValue(LANGUAGE_OPTION)).length() != 2) {
            System.err.println("Error: \"" + language + "\" unknown language!");
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT_OPTION);
        LOG.info((Object)("Tool name: " + ((Object)((Object)this)).getClass().getName()));
        LOG.info((Object)(" - XML dump file: " + inputPath));
        LOG.info((Object)(" - language: " + language));
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJarByClass(CountWikipediaPages.class);
        job.setJobName(String.format("CountWikipediaPages[%s: %s, %s: %s]", INPUT_OPTION, inputPath, LANGUAGE_OPTION, language));
        job.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        if (language != null) {
            job.getConfiguration().set("wiki.language", language);
        }
        job.setInputFormatClass(WikipediaPageInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new CountWikipediaPages(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends Mapper<LongWritable, WikipediaPage, Text, IntWritable> {
        private MyMapper() {
        }

        public void map(LongWritable key, WikipediaPage p, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)PageTypes.TOTAL).increment(1L);
            if (p.isRedirect()) {
                context.getCounter((Enum)PageTypes.REDIRECT).increment(1L);
            } else if (p.isDisambiguation()) {
                context.getCounter((Enum)PageTypes.DISAMBIGUATION).increment(1L);
            } else if (p.isEmpty()) {
                context.getCounter((Enum)PageTypes.EMPTY).increment(1L);
            } else if (p.isArticle()) {
                context.getCounter((Enum)PageTypes.ARTICLE).increment(1L);
                if (p.isStub()) {
                    context.getCounter((Enum)PageTypes.STUB).increment(1L);
                }
            } else {
                context.getCounter((Enum)PageTypes.OTHER).increment(1L);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PageTypes {
        TOTAL,
        REDIRECT,
        DISAMBIGUATION,
        EMPTY,
        ARTICLE,
        STUB,
        OTHER;

    }
}

