/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.wikipedia.WikipediaForwardIndex;
import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LookupWikipediaArticle
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("usage: [forward-index-path] [docno-mapping-data-file]");
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        Configuration conf = this.getConf();
        WikipediaForwardIndex f = new WikipediaForwardIndex(conf);
        f.loadIndex(new Path(args[0]), new Path(args[1]), FileSystem.get((Configuration)conf));
        System.out.println(" \"docno [no]\" or \"docid [id]\" to lookup documents");
        String cmd = null;
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("lookup > ");
        while ((cmd = stdin.readLine()) != null) {
            block11: {
                WikipediaPage page;
                String[] tokens = cmd.split("\\s+");
                if (tokens.length != 2) {
                    System.out.println("Error: unrecognized command!");
                    System.out.print("lookup > ");
                    continue;
                }
                if ("docno".equals(tokens[0])) {
                    try {
                        page = f.getDocument(Integer.parseInt(tokens[1]));
                        if (page != null) {
                            System.out.println("docid " + page.getDocid() + ": " + page.getTitle());
                            break block11;
                        }
                        System.out.println("docno " + tokens[1] + " not found!");
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid docno " + tokens[1]);
                    }
                } else if ("docid".equals(tokens[0])) {
                    page = f.getDocument(tokens[1]);
                    if (page != null) {
                        System.out.println("docid " + page.getDocid() + ": " + page.getTitle());
                    } else {
                        System.out.println("docid " + tokens[1] + " not found!");
                    }
                }
            }
            System.out.print("lookup > ");
        }
        return 0;
    }

    private LookupWikipediaArticle() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new LookupWikipediaArticle(), (String[])args);
    }
}

