/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia;

import edu.umd.cloud9.collection.IndexableFileInputFormatOld;
import edu.umd.cloud9.collection.XMLInputFormatOld;
import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.WikipediaPageFactory;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikipediaPageInputFormatOld
extends IndexableFileInputFormatOld<LongWritable, WikipediaPage> {
    public RecordReader<LongWritable, WikipediaPage> getRecordReader(InputSplit inputSplit, JobConf conf, Reporter reporter) throws IOException {
        return new WikipediaPageRecordReader((FileSplit)inputSplit, conf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WikipediaPageRecordReader
    implements RecordReader<LongWritable, WikipediaPage> {
        private XMLInputFormatOld.XMLRecordReader reader;
        private Text text = new Text();
        private LongWritable offset = new LongWritable();
        private String language;

        public WikipediaPageRecordReader(FileSplit split, JobConf conf) throws IOException {
            conf.set("xmlinput.start", "<page>");
            conf.set("xmlinput.end", "</page>");
            this.language = conf.get("wiki.language", "en");
            this.reader = new XMLInputFormatOld.XMLRecordReader(split, conf);
        }

        public boolean next(LongWritable key, WikipediaPage value) throws IOException {
            if (!this.reader.next(this.offset, this.text)) {
                return false;
            }
            key.set(this.offset.get());
            WikipediaPage.readPage(value, this.text.toString());
            return true;
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public WikipediaPage createValue() {
            return WikipediaPageFactory.createWikipediaPage(this.language);
        }

        public long getPos() throws IOException {
            return this.reader.getPos();
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public float getProgress() throws IOException {
            return (float)(this.reader.getPos() - this.reader.getStart()) / (float)(this.reader.getEnd() - this.reader.getStart());
        }
    }
}

