/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia.graph;

import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapFileOutputFormat;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.map.HMapStIW;
import tl.lin.data.pair.PairOfIntString;
import tl.lin.data.pair.PairOfStringInt;
import tl.lin.data.pair.PairOfStrings;

public class ExtractWikipediaAnchorText
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(ExtractWikipediaAnchorText.class);
    private static final String INPUT_OPTION = "input";
    private static final String OUTPUT_OPTION = "output";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)INPUT_OPTION);
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output for adjacency list");
        options.addOption(OptionBuilder.create((String)OUTPUT_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT_OPTION) || !cmdline.hasOption(OUTPUT_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        Random random = new Random();
        String tmp = "tmp-" + ((Object)((Object)this)).getClass().getCanonicalName() + "-" + random.nextInt(10000);
        this.task1(cmdline.getOptionValue(INPUT_OPTION), tmp);
        this.task2(tmp, cmdline.getOptionValue(OUTPUT_OPTION));
        return 0;
    }

    private void task1(String inputPath, String outputPath) throws IOException {
        LOG.info((Object)"Exracting anchor text (phase 1)...");
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output: " + outputPath));
        JobConf conf = new JobConf(this.getConf(), ExtractWikipediaAnchorText.class);
        conf.setJobName(String.format("ExtractWikipediaAnchorText:phase1[input: %s, output: %s]", inputPath, outputPath));
        conf.setNumReduceTasks(10);
        SequenceFileInputFormat.addInputPath((JobConf)conf, (Path)new Path(inputPath));
        TextOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setMapOutputKeyClass(PairOfStringInt.class);
        conf.setMapOutputValueClass(PairOfStrings.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(PairOfIntString.class);
        conf.setMapperClass(MyMapper1.class);
        conf.setReducerClass(MyReducer1.class);
        conf.setPartitionerClass(MyPartitioner1.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        JobClient.runJob((JobConf)conf);
    }

    private void task2(String inputPath, String outputPath) throws IOException {
        LOG.info((Object)"Exracting anchor text (phase 2)...");
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output: " + outputPath));
        JobConf conf = new JobConf(this.getConf(), ExtractWikipediaAnchorText.class);
        conf.setJobName(String.format("ExtractWikipediaAnchorText:phase2[input: %s, output: %s]", inputPath, outputPath));
        conf.setNumReduceTasks(1);
        TextInputFormat.addInputPath((JobConf)conf, (Path)new Path(inputPath));
        TextOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(MapFileOutputFormat.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(HMapStIW.class);
        conf.setMapperClass(MyMapper2.class);
        conf.setReducerClass(MyReducer2.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        JobClient.runJob((JobConf)conf);
        FileSystem.get((Configuration)conf).delete(new Path(inputPath), true);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new ExtractWikipediaAnchorText(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer2
    extends MapReduceBase
    implements Reducer<IntWritable, Text, IntWritable, HMapStIW> {
        private static final HMapStIW map = new HMapStIW();

        private MyReducer2() {
        }

        public void reduce(IntWritable key, Iterator<Text> values, OutputCollector<IntWritable, HMapStIW> output, Reporter reporter) throws IOException {
            map.clear();
            while (values.hasNext()) {
                Text cur = values.next();
                map.increment((Comparable)((Object)cur.toString()));
            }
            output.collect((Object)key, (Object)map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper2
    extends MapReduceBase
    implements Mapper<IntWritable, PairOfIntString, IntWritable, Text> {
        private static final IntWritable KEY = new IntWritable();
        private static final Text VALUE = new Text();

        private MyMapper2() {
        }

        public void map(IntWritable key, PairOfIntString t, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            KEY.set(t.getLeftElement());
            VALUE.set(t.getRightElement());
            output.collect((Object)KEY, (Object)VALUE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyPartitioner1
    implements Partitioner<PairOfStringInt, PairOfStrings> {
        private MyPartitioner1() {
        }

        public void configure(JobConf job) {
        }

        public int getPartition(PairOfStringInt key, PairOfStrings value, int numReduceTasks) {
            return (key.getLeftElement().hashCode() & Integer.MAX_VALUE) % numReduceTasks;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer1
    extends MapReduceBase
    implements Reducer<PairOfStringInt, PairOfStrings, IntWritable, PairOfIntString> {
        private static final IntWritable SRCID = new IntWritable();
        private static final PairOfIntString TARGET_ANCHOR_PAIR = new PairOfIntString();
        private String targetTitle;
        private int targetDocid;

        private MyReducer1() {
        }

        public void reduce(PairOfStringInt key, Iterator<PairOfStrings> values, OutputCollector<IntWritable, PairOfIntString> output, Reporter reporter) throws IOException {
            if (key.getRightElement() == 0) {
                this.targetTitle = key.getLeftElement();
                this.targetDocid = Integer.parseInt(values.next().getLeftElement());
            } else {
                if (!key.getLeftElement().equals(this.targetTitle)) {
                    return;
                }
                while (values.hasNext()) {
                    PairOfStrings pair = values.next();
                    SRCID.set(Integer.parseInt(pair.getLeftElement()));
                    TARGET_ANCHOR_PAIR.set(this.targetDocid, pair.getRightElement());
                    output.collect((Object)SRCID, (Object)TARGET_ANCHOR_PAIR);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper1
    extends MapReduceBase
    implements Mapper<IntWritable, WikipediaPage, PairOfStringInt, PairOfStrings> {
        private static final PairOfStringInt KEYPAIR = new PairOfStringInt();
        private static final PairOfStrings VALUEPAIR = new PairOfStrings();

        private MyMapper1() {
        }

        public void map(IntWritable key, WikipediaPage p, OutputCollector<PairOfStringInt, PairOfStrings> output, Reporter reporter) throws IOException {
            reporter.incrCounter((Enum)PageTypes.TOTAL, 1L);
            String title = p.getTitle();
            VALUEPAIR.set(p.getDocid(), "");
            KEYPAIR.set(title, 0);
            output.collect((Object)KEYPAIR, (Object)VALUEPAIR);
            String fc = title.substring(0, 1);
            if (fc.matches("[A-Z]")) {
                title = title.replaceFirst(fc, fc.toLowerCase());
                KEYPAIR.set(title, 0);
                output.collect((Object)KEYPAIR, (Object)VALUEPAIR);
            }
            if (p.isRedirect()) {
                reporter.incrCounter((Enum)PageTypes.REDIRECT, 1L);
            } else if (p.isDisambiguation()) {
                reporter.incrCounter((Enum)PageTypes.DISAMBIGUATION, 1L);
            } else if (p.isEmpty()) {
                reporter.incrCounter((Enum)PageTypes.EMPTY, 1L);
            } else if (p.isArticle()) {
                reporter.incrCounter((Enum)PageTypes.ARTICLE, 1L);
                if (p.isStub()) {
                    reporter.incrCounter((Enum)PageTypes.STUB, 1L);
                }
            } else {
                reporter.incrCounter((Enum)PageTypes.NON_ARTICLE, 1L);
            }
            for (WikipediaPage.Link link : p.extractLinks()) {
                KEYPAIR.set(link.getTarget(), 1);
                VALUEPAIR.set(p.getDocid(), link.getAnchorText());
                output.collect((Object)KEYPAIR, (Object)VALUEPAIR);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PageTypes {
        TOTAL,
        REDIRECT,
        DISAMBIGUATION,
        EMPTY,
        ARTICLE,
        STUB,
        NON_ARTICLE;

    }
}

