/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia.graph;

import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.pair.PairOfStringInt;

public class ExtractWikipediaLinkGraph
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(ExtractWikipediaLinkGraph.class);
    private static final String INPUT_OPTION = "input";
    private static final String EDGES_OUTPUT_OPTION = "edges_output";
    private static final String ADJ_OUTPUT_OPTION = "adjacency_list_output";
    private static final String NUM_PARTITIONS_OPTION = "num_partitions";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)INPUT_OPTION);
        options.addOption(OptionBuilder.create((String)INPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output for edges");
        options.addOption(OptionBuilder.create((String)EDGES_OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output for adjacency list");
        options.addOption(OptionBuilder.create((String)ADJ_OUTPUT_OPTION));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of partitions");
        options.addOption(OptionBuilder.create((String)NUM_PARTITIONS_OPTION));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(INPUT_OPTION) && cmdline.hasOption(EDGES_OUTPUT_OPTION) && cmdline.hasOption(ADJ_OUTPUT_OPTION) && cmdline.hasOption(NUM_PARTITIONS_OPTION))) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        int numPartitions = Integer.parseInt(cmdline.getOptionValue(NUM_PARTITIONS_OPTION));
        this.task1(cmdline.getOptionValue(INPUT_OPTION), cmdline.getOptionValue(EDGES_OUTPUT_OPTION), numPartitions);
        this.task2(cmdline.getOptionValue(EDGES_OUTPUT_OPTION), cmdline.getOptionValue(ADJ_OUTPUT_OPTION), numPartitions);
        return 0;
    }

    private void task1(String inputPath, String outputPath, int partitions) throws IOException {
        LOG.info((Object)"Exracting edges...");
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output: " + outputPath));
        JobConf conf = new JobConf(this.getConf(), ExtractWikipediaLinkGraph.class);
        conf.setJobName(String.format("ExtractWikipediaLinkGraph:Edges[input: %s, output: %s, num_partitions: %d]", inputPath, outputPath, partitions));
        conf.setNumReduceTasks(partitions);
        SequenceFileInputFormat.addInputPath((JobConf)conf, (Path)new Path(inputPath));
        TextOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setMapOutputKeyClass(PairOfStringInt.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(MyMapper1.class);
        conf.setReducerClass(MyReducer1.class);
        conf.setPartitionerClass(MyPartitioner1.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        JobClient.runJob((JobConf)conf);
    }

    private void task2(String inputPath, String outputPath, int partitions) throws IOException {
        LOG.info((Object)"Building adjacency lists...");
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output: " + outputPath));
        JobConf conf = new JobConf(this.getConf(), ExtractWikipediaLinkGraph.class);
        conf.setJobName(String.format("ExtractWikipediaLinkGraph:AdjacencyList[input: %s, output: %s, num_partitions: %d]", inputPath, outputPath, partitions));
        conf.setNumReduceTasks(partitions);
        TextInputFormat.addInputPath((JobConf)conf, (Path)new Path(inputPath));
        TextOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(IntWritable.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(MyMapper2.class);
        conf.setReducerClass(MyReducer2.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        JobClient.runJob((JobConf)conf);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new ExtractWikipediaLinkGraph(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer2
    extends MapReduceBase
    implements Reducer<IntWritable, IntWritable, IntWritable, Text> {
        private static final Text text = new Text();

        private MyReducer2() {
        }

        public void reduce(IntWritable key, Iterator<IntWritable> values, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            StringBuilder sb = new StringBuilder();
            HashSet<Integer> set = new HashSet<Integer>();
            reporter.incrCounter((Enum)GraphInfo.TOTAL_VERTICES, 1L);
            while (values.hasNext()) {
                IntWritable cur = values.next();
                if (cur.get() == key.get() || set.contains(cur.get())) continue;
                set.add(cur.get());
                reporter.incrCounter((Enum)GraphInfo.EDGES, 1L);
                sb.append(cur.get());
                sb.append("\t");
            }
            if (set.size() != 0) {
                reporter.incrCounter((Enum)GraphInfo.VERTICES_WITH_OUTLINKS, 1L);
            }
            text.set(sb.toString());
            output.collect((Object)key, (Object)text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper2
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, IntWritable> {
        private static IntWritable keyOut = new IntWritable();
        private static IntWritable valOut = new IntWritable();

        private MyMapper2() {
        }

        public void map(LongWritable key, Text t, OutputCollector<IntWritable, IntWritable> output, Reporter reporter) throws IOException {
            String[] arr = t.toString().split("\\s+");
            keyOut.set(Integer.parseInt(arr[0]));
            valOut.set(Integer.parseInt(arr[1]));
            output.collect((Object)keyOut, (Object)valOut);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyPartitioner1
    implements Partitioner<PairOfStringInt, Text> {
        private MyPartitioner1() {
        }

        public void configure(JobConf job) {
        }

        public int getPartition(PairOfStringInt key, Text value, int numReduceTasks) {
            return (key.getLeftElement().hashCode() & Integer.MAX_VALUE) % numReduceTasks;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer1
    extends MapReduceBase
    implements Reducer<PairOfStringInt, Text, IntWritable, IntWritable> {
        private static final IntWritable finalSrc = new IntWritable();
        private static final IntWritable finalDest = new IntWritable();
        private static String curArticle;
        private static int curDocid;

        private MyReducer1() {
        }

        public void reduce(PairOfStringInt key, Iterator<Text> values, OutputCollector<IntWritable, IntWritable> output, Reporter reporter) throws IOException {
            if (key.getRightElement() == 0) {
                curArticle = key.getLeftElement();
                curDocid = Integer.parseInt(values.next().toString());
                finalSrc.set(curDocid);
                finalDest.set(curDocid);
                output.collect((Object)finalSrc, (Object)finalDest);
            } else {
                if (!key.getLeftElement().equals(curArticle)) {
                    return;
                }
                while (values.hasNext()) {
                    finalSrc.set(Integer.parseInt(values.next().toString()));
                    finalDest.set(curDocid);
                    output.collect((Object)finalSrc, (Object)finalDest);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper1
    extends MapReduceBase
    implements Mapper<IntWritable, WikipediaPage, PairOfStringInt, Text> {
        private static Text text = new Text();
        private static PairOfStringInt pair = new PairOfStringInt();

        private MyMapper1() {
        }

        public void map(IntWritable key, WikipediaPage p, OutputCollector<PairOfStringInt, Text> output, Reporter reporter) throws IOException {
            reporter.incrCounter((Enum)PageTypes.TOTAL, 1L);
            String title = p.getTitle();
            text.set(p.getDocid());
            pair.set(title, 0);
            output.collect((Object)pair, (Object)text);
            String fc = title.substring(0, 1);
            if (fc.matches("[A-Z]")) {
                title = title.replaceFirst(fc, fc.toLowerCase());
                pair.set(title, 0);
                output.collect((Object)pair, (Object)text);
            }
            if (p.isRedirect()) {
                reporter.incrCounter((Enum)PageTypes.REDIRECT, 1L);
            } else if (p.isDisambiguation()) {
                reporter.incrCounter((Enum)PageTypes.DISAMBIGUATION, 1L);
            } else if (p.isEmpty()) {
                reporter.incrCounter((Enum)PageTypes.EMPTY, 1L);
            } else if (p.isArticle()) {
                reporter.incrCounter((Enum)PageTypes.ARTICLE, 1L);
                if (p.isStub()) {
                    reporter.incrCounter((Enum)PageTypes.STUB, 1L);
                }
            } else {
                reporter.incrCounter((Enum)PageTypes.NON_ARTICLE, 1L);
            }
            for (String t : p.extractLinkTargets()) {
                pair.set(t, 1);
                text.set(p.getDocid());
                output.collect((Object)pair, (Object)text);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GraphInfo {
        TOTAL_VERTICES,
        VERTICES_WITH_OUTLINKS,
        EDGES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PageTypes {
        TOTAL,
        REDIRECT,
        DISAMBIGUATION,
        EMPTY,
        ARTICLE,
        STUB,
        NON_ARTICLE;

    }
}

