/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.collection.wikipedia.language;

import edu.umd.cloud9.collection.wikipedia.WikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.ArabicWikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.ChineseWikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.CzechWikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.EnglishWikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.GermanWikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.SpanishWikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.SwedishWikipediaPage;
import edu.umd.cloud9.collection.wikipedia.language.TurkishWikipediaPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikipediaPageFactory {
    public static WikipediaPage createWikipediaPage(String language) {
        if (language == null) {
            return new EnglishWikipediaPage();
        }
        if (language.equalsIgnoreCase("en")) {
            return new EnglishWikipediaPage();
        }
        if (language.equalsIgnoreCase("sv")) {
            return new SwedishWikipediaPage();
        }
        if (language.equalsIgnoreCase("de")) {
            return new GermanWikipediaPage();
        }
        if (language.equalsIgnoreCase("cs")) {
            return new CzechWikipediaPage();
        }
        if (language.equalsIgnoreCase("es")) {
            return new SpanishWikipediaPage();
        }
        if (language.equalsIgnoreCase("ar")) {
            return new ArabicWikipediaPage();
        }
        if (language.equalsIgnoreCase("tr")) {
            return new TurkishWikipediaPage();
        }
        if (language.equalsIgnoreCase("zh")) {
            return new ChineseWikipediaPage();
        }
        return new EnglishWikipediaPage();
    }

    public static Class<? extends WikipediaPage> getWikipediaPageClass(String language) {
        if (language == null) {
            return EnglishWikipediaPage.class;
        }
        if (language.equalsIgnoreCase("en")) {
            return EnglishWikipediaPage.class;
        }
        if (language.equalsIgnoreCase("sv")) {
            return SwedishWikipediaPage.class;
        }
        if (language.equalsIgnoreCase("de")) {
            return GermanWikipediaPage.class;
        }
        return EnglishWikipediaPage.class;
    }
}

