/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.bfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import tl.lin.data.array.ArrayListOfIntsWritable;

public class BfsNode
implements Writable {
    private static final Type[] mapping = new Type[]{Type.Complete, Type.Distance, Type.Structure};
    private Type type;
    private int nodeid;
    private int distance;
    private ArrayListOfIntsWritable adjacenyList;

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int d) {
        this.distance = d;
    }

    public int getNodeId() {
        return this.nodeid;
    }

    public void setNodeId(int n) {
        this.nodeid = n;
    }

    public ArrayListOfIntsWritable getAdjacenyList() {
        return this.adjacenyList;
    }

    public void setAdjacencyList(ArrayListOfIntsWritable l) {
        this.adjacenyList = l;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void readFields(DataInput in) throws IOException {
        this.type = mapping[in.readByte()];
        this.nodeid = in.readInt();
        if (this.type.equals((Object)Type.Distance)) {
            this.distance = in.readInt();
            return;
        }
        if (this.type.equals((Object)Type.Complete)) {
            this.distance = in.readInt();
        }
        this.adjacenyList = new ArrayListOfIntsWritable();
        this.adjacenyList.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.type.val);
        out.writeInt(this.nodeid);
        if (this.type.equals((Object)Type.Distance)) {
            out.writeInt(this.distance);
            return;
        }
        if (this.type.equals((Object)Type.Complete)) {
            out.writeInt(this.distance);
        }
        this.adjacenyList.write(out);
    }

    public String toString() {
        return String.format("{%d %d %s}", this.nodeid, this.distance, this.adjacenyList == null ? "[]" : this.adjacenyList.toString(10));
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static BfsNode create(DataInput in) throws IOException {
        BfsNode m = new BfsNode();
        m.readFields(in);
        return m;
    }

    public static BfsNode create(byte[] bytes) throws IOException {
        return BfsNode.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Complete(0),
        Distance(1),
        Structure(2);

        public byte val;

        private Type(byte v) {
            this.val = v;
        }
    }
}

