/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.bigram;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BinSedesTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class BigramRelativeFrequencyTuple
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(BigramRelativeFrequencyTuple.class);
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String NUM_REDUCERS = "numReducers";

    private BigramRelativeFrequencyTuple() {
    }

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of reducers");
        options.addOption(OptionBuilder.create((String)NUM_REDUCERS));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT) || !cmdline.hasOption(OUTPUT)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT);
        String outputPath = cmdline.getOptionValue(OUTPUT);
        int reduceTasks = cmdline.hasOption(NUM_REDUCERS) ? Integer.parseInt(cmdline.getOptionValue(NUM_REDUCERS)) : 1;
        LOG.info((Object)("Tool name: " + BigramRelativeFrequencyTuple.class.getSimpleName()));
        LOG.info((Object)(" - input path: " + inputPath));
        LOG.info((Object)(" - output path: " + outputPath));
        LOG.info((Object)(" - num reducers: " + reduceTasks));
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(BigramRelativeFrequencyTuple.class.getSimpleName());
        job.setJarByClass(BigramRelativeFrequencyTuple.class);
        job.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setMapOutputKeyClass(BinSedesTuple.class);
        job.setMapOutputValueClass(FloatWritable.class);
        job.setOutputKeyClass(BinSedesTuple.class);
        job.setOutputValueClass(FloatWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setCombinerClass(MyCombiner.class);
        job.setReducerClass(MyReducer.class);
        job.setPartitionerClass(MyPartitioner.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)this.getConf()).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        System.out.println("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new BigramRelativeFrequencyTuple(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyPartitioner
    extends Partitioner<Tuple, FloatWritable> {
        protected MyPartitioner() {
        }

        public int getPartition(Tuple key, FloatWritable value, int numReduceTasks) {
            try {
                return (((String)key.get(0)).hashCode() & Integer.MAX_VALUE) % numReduceTasks;
            }
            catch (ExecException e) {
                e.printStackTrace();
                return 0;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyReducer
    extends Reducer<Tuple, FloatWritable, Tuple, FloatWritable> {
        private static final FloatWritable VALUE = new FloatWritable();
        private float marginal = 0.0f;

        protected MyReducer() {
        }

        public void reduce(Tuple key, Iterable<FloatWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            float sum = 0.0f;
            Iterator<FloatWritable> iter = values.iterator();
            while (iter.hasNext()) {
                sum += iter.next().get();
            }
            if (key.get(1).equals("*")) {
                VALUE.set(sum);
                context.write((Object)key, (Object)VALUE);
                this.marginal = sum;
            } else {
                VALUE.set(sum / this.marginal);
                context.write((Object)key, (Object)VALUE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyCombiner
    extends Reducer<Tuple, FloatWritable, Tuple, FloatWritable> {
        private static final FloatWritable SUM = new FloatWritable();

        protected MyCombiner() {
        }

        public void reduce(Tuple key, Iterable<FloatWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            Iterator<FloatWritable> iter = values.iterator();
            while (iter.hasNext()) {
                sum = (int)((float)sum + iter.next().get());
            }
            SUM.set((float)sum);
            context.write((Object)key, (Object)SUM);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyMapper
    extends Mapper<LongWritable, Text, Tuple, FloatWritable> {
        private static final FloatWritable ONE = new FloatWritable(1.0f);

        protected MyMapper() {
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String line = value.toString();
            String prev = null;
            StringTokenizer itr = new StringTokenizer(line);
            while (itr.hasMoreTokens()) {
                String cur = itr.nextToken();
                if (prev != null) {
                    if (cur.length() > 100) {
                        cur = cur.substring(0, 100);
                    }
                    if (prev.length() > 100) {
                        prev = prev.substring(0, 100);
                    }
                    Tuple tuple1 = TUPLE_FACTORY.newTuple();
                    tuple1.append((Object)prev);
                    tuple1.append((Object)cur);
                    context.write((Object)tuple1, (Object)ONE);
                    Tuple tuple2 = TUPLE_FACTORY.newTuple();
                    tuple2.append((Object)prev);
                    tuple2.append((Object)"*");
                    context.write((Object)tuple2, (Object)ONE);
                }
                prev = cur;
            }
        }
    }
}

