/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.clustering;

import com.google.common.collect.Sets;
import edu.umd.cloud9.example.clustering.PVector;
import edu.umd.cloud9.example.clustering.Point;
import edu.umd.cloud9.example.clustering.UnivariateGaussianMixtureModel;
import java.util.HashSet;
import java.util.Random;

public class ExpectationMaximization {
    private static int MAX_ITERATIONS = 30;

    public static UnivariateGaussianMixtureModel initialize(Point[] points, double[] means) {
        UnivariateGaussianMixtureModel mm = new UnivariateGaussianMixtureModel(means.length);
        for (int i = 0; i < means.length; ++i) {
            mm.weight[i] = 1.0f / (float)means.length;
            PVector param = new PVector(2);
            Point tmpPoint = null;
            double minD = Double.MAX_VALUE;
            for (int j = 0; j < points.length; ++j) {
                double d = Math.abs(points[j].value - means[i]);
                if (!(d < minD)) continue;
                tmpPoint = points[j];
                minD = d;
            }
            param.array[0] = tmpPoint.value;
            param.array[1] = 1.0;
            mm.param[i] = param;
        }
        return mm;
    }

    public static UnivariateGaussianMixtureModel initialize(Point[] points, int n) {
        UnivariateGaussianMixtureModel mm = new UnivariateGaussianMixtureModel(n);
        Integer[] arr = ExpectationMaximization.sampleNUniquePoints(n, points.length);
        for (int i = 0; i < n; ++i) {
            mm.weight[i] = 1.0f / (float)n;
            PVector param = new PVector(2);
            param.array[0] = points[arr[i].intValue()].value;
            param.array[1] = 1.0;
            mm.param[i] = param;
        }
        return mm;
    }

    public static UnivariateGaussianMixtureModel run(Point[] points, UnivariateGaussianMixtureModel m) {
        double logLikelihoodOld;
        UnivariateGaussianMixtureModel mixtureModel = m.clone();
        int numComponents = mixtureModel.size;
        int numPoints = points.length;
        int iterations = 0;
        double[][] p = new double[numPoints][numComponents];
        double logLikelihoodNew = ExpectationMaximization.logLikelihood(points, mixtureModel);
        double logLikelihoodThreshold = 1.0E-9;
        System.out.printf("Iteration %2d: LL = %12.6f\n", iterations, logLikelihoodNew);
        do {
            int k;
            double sum;
            int n;
            logLikelihoodOld = logLikelihoodNew;
            for (n = 0; n < numPoints; ++n) {
                sum = 0.0;
                for (k = 0; k < numComponents; ++k) {
                    double tmp;
                    p[n][k] = tmp = mixtureModel.weight[k] * UnivariateGaussianMixtureModel.densityOfGaussian(points[n], mixtureModel.param[k]);
                    sum += tmp;
                }
                k = 0;
                while (k < numComponents) {
                    double[] dArray = p[n];
                    int n2 = k++;
                    dArray[n2] = dArray[n2] / sum;
                }
            }
            for (k = 0; k < numComponents; ++k) {
                sum = 0.0;
                double mu = 0.0;
                double sigma = 0.0;
                for (n = 0; n < numPoints; ++n) {
                    double w = p[n][k];
                    sum += w;
                    mu += points[n].value * w;
                }
                mu /= sum;
                for (n = 0; n < numPoints; ++n) {
                    double diff = points[n].value - mu;
                    sigma += p[n][k] * diff * diff;
                }
                PVector param = new PVector(2);
                param.array[0] = mu;
                param.array[1] = sigma /= sum;
                mixtureModel.param[k] = param;
                mixtureModel.weight[k] = sum / (double)numPoints;
            }
            logLikelihoodNew = ExpectationMaximization.logLikelihood(points, mixtureModel);
            System.out.printf("Iteration %2d: LL = %12.6f\n", ++iterations, logLikelihoodNew);
        } while (Math.abs((logLikelihoodNew - logLikelihoodOld) / logLikelihoodOld) > logLikelihoodThreshold && iterations < MAX_ITERATIONS);
        return mixtureModel;
    }

    private static double logLikelihood(Point[] points, UnivariateGaussianMixtureModel f) {
        double value = 0.0;
        for (int i = 0; i < points.length; ++i) {
            value += Math.log(f.density(points[i]));
        }
        return value;
    }

    public static final Integer[] sampleNUniquePoints(int n, int length) {
        Random rand = new Random();
        HashSet set = Sets.newHashSet();
        while (set.size() < n) {
            int r = rand.nextInt(length);
            if (set.contains(r)) continue;
            set.add(r);
        }
        return set.toArray(new Integer[set.size()]);
    }
}

