/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.cooccur;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.pair.PairOfStrings;

public class ComputeCooccurrenceMatrixPairs
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(ComputeCooccurrenceMatrixPairs.class);
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String WINDOW = "window";
    private static final String NUM_REDUCERS = "numReducers";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"window size");
        options.addOption(OptionBuilder.create((String)WINDOW));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of reducers");
        options.addOption(OptionBuilder.create((String)NUM_REDUCERS));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT) || !cmdline.hasOption(OUTPUT)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT);
        String outputPath = cmdline.getOptionValue(OUTPUT);
        int reduceTasks = cmdline.hasOption(NUM_REDUCERS) ? Integer.parseInt(cmdline.getOptionValue(NUM_REDUCERS)) : 1;
        int window = cmdline.hasOption(WINDOW) ? Integer.parseInt(cmdline.getOptionValue(WINDOW)) : 2;
        LOG.info((Object)("Tool: " + ComputeCooccurrenceMatrixPairs.class.getSimpleName()));
        LOG.info((Object)(" - input path: " + inputPath));
        LOG.info((Object)(" - output path: " + outputPath));
        LOG.info((Object)(" - window: " + window));
        LOG.info((Object)(" - number of reducers: " + reduceTasks));
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(ComputeCooccurrenceMatrixPairs.class.getSimpleName());
        job.setJarByClass(ComputeCooccurrenceMatrixPairs.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)this.getConf()).delete(outputDir, true);
        job.getConfiguration().setInt(WINDOW, window);
        job.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setMapOutputKeyClass(PairOfStrings.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputKeyClass(PairOfStrings.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(MyMapper.class);
        job.setCombinerClass(MyReducer.class);
        job.setReducerClass(MyReducer.class);
        job.setPartitionerClass(MyPartitioner.class);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        System.out.println("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new ComputeCooccurrenceMatrixPairs(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyPartitioner
    extends Partitioner<PairOfStrings, IntWritable> {
        protected MyPartitioner() {
        }

        public int getPartition(PairOfStrings key, IntWritable value, int numReduceTasks) {
            return (key.getLeftElement().hashCode() & Integer.MAX_VALUE) % numReduceTasks;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer
    extends Reducer<PairOfStrings, IntWritable, PairOfStrings, IntWritable> {
        private static final IntWritable SUM = new IntWritable();

        private MyReducer() {
        }

        public void reduce(PairOfStrings key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            Iterator<IntWritable> iter = values.iterator();
            int sum = 0;
            while (iter.hasNext()) {
                sum += iter.next().get();
            }
            SUM.set(sum);
            context.write((Object)key, (Object)SUM);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends Mapper<LongWritable, Text, PairOfStrings, IntWritable> {
        private static final PairOfStrings PAIR = new PairOfStrings();
        private static final IntWritable ONE = new IntWritable(1);
        private int window = 2;

        private MyMapper() {
        }

        public void setup(Mapper.Context context) {
            this.window = context.getConfiguration().getInt(ComputeCooccurrenceMatrixPairs.WINDOW, 2);
        }

        public void map(LongWritable key, Text line, Mapper.Context context) throws IOException, InterruptedException {
            String text = line.toString();
            String[] terms = text.split("\\s+");
            block0: for (int i = 0; i < terms.length; ++i) {
                String term = terms[i];
                if (term.length() == 0) continue;
                for (int j = i - this.window; j < i + this.window + 1; ++j) {
                    if (j == i || j < 0) continue;
                    if (j >= terms.length) continue block0;
                    if (terms[j].length() == 0) continue;
                    PAIR.set(term, terms[j]);
                    context.write((Object)PAIR, (Object)ONE);
                }
            }
        }
    }
}

