/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.hbase;

import edu.umd.cloud9.example.hbase.HBaseWordCount;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class HBaseWordCountFetch
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(HBaseWordCountFetch.class);
    private static final String TABLE = "table";
    private static final String WORD = "word";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)TABLE);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"HBase table name");
        options.addOption(OptionBuilder.create((String)TABLE));
        OptionBuilder.withArgName((String)WORD);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"word to look up");
        options.addOption(OptionBuilder.create((String)WORD));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(TABLE) || !cmdline.hasOption(WORD)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String tableName = cmdline.getOptionValue(TABLE);
        String word = cmdline.getOptionValue(WORD);
        Configuration conf = this.getConf();
        conf.addResource(new Path("/etc/hbase/conf/hbase-site.xml"));
        Configuration hbaseConfig = HBaseConfiguration.create((Configuration)conf);
        HConnection hbaseConnection = HConnectionManager.createConnection((Configuration)hbaseConfig);
        HTableInterface table = hbaseConnection.getTable(tableName);
        Get get = new Get(Bytes.toBytes((String)word));
        Result result = table.get(get);
        int count = Bytes.toInt((byte[])result.getValue(HBaseWordCount.CF, HBaseWordCount.COUNT));
        LOG.info((Object)("word: " + word + ", count: " + count));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new HBaseWordCountFetch(), (String[])args);
    }
}

