/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.hits;

import edu.umd.cloud9.example.hits.HITSNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.array.ArrayListOfIntsWritable;
import tl.lin.data.map.HMapIV;
import tl.lin.data.map.MapIV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFormatterWG
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(AFormatterWG.class);

    private static int printUsage() {
        System.out.println("usage: [input-path] [output-path] [num-mappers] [num-reducers] [stoplist-path]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 5) {
            AFormatterWG.printUsage();
            return -1;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        int mapTasks = Integer.parseInt(args[2]);
        int reduceTasks = Integer.parseInt(args[3]);
        String stoplistPath = args[4];
        sLogger.info((Object)"Tool: AFormatter");
        sLogger.info((Object)(" - input path: " + inputPath));
        sLogger.info((Object)(" - output path: " + outputPath));
        sLogger.info((Object)(" - number of mappers: " + mapTasks));
        sLogger.info((Object)(" - number of reducers: " + reduceTasks));
        JobConf conf = new JobConf(AFormatterWG.class);
        conf.setJobName("Authority Formatter -- Web Graph");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(HITSNode.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setSpeculativeExecution(false);
        conf.setMapperClass(AFormatMapperIMC.class);
        conf.setCombinerClass(AFormatReducer.class);
        conf.setReducerClass(AFormatReducer.class);
        Path outputDir = new Path(outputPath);
        Path stopList = new Path(stoplistPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        sLogger.info((Object)"Starting job");
        DistributedCache.addCacheFile((URI)stopList.toUri(), (Configuration)conf);
        conf.setStrings("stoplist", new String[]{stopList.toString()});
        JobClient.runJob((JobConf)conf);
        sLogger.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        return 0;
    }

    private static HashSet<Integer> readStopList(JobConf jc) {
        HashSet<Integer> out = new HashSet<Integer>();
        try {
            String line;
            Path[] cacheFiles = DistributedCache.getLocalCacheFiles((Configuration)jc);
            FileReader fr = new FileReader(cacheFiles[0].toString());
            BufferedReader stopReader = new BufferedReader(fr);
            while ((line = stopReader.readLine()) != null) {
                out.add(Integer.parseInt(line));
            }
            stopReader.close();
            return out;
        }
        catch (IOException ioe) {
            System.err.println("IOException reading from distributed cache");
            System.err.println(ioe.toString());
            return out;
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new AFormatterWG(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AFormatReducer
    extends MapReduceBase
    implements Reducer<IntWritable, HITSNode, IntWritable, HITSNode> {
        private HITSNode valIn;
        private HITSNode valOut = new HITSNode();
        ArrayListOfIntsWritable adjList = new ArrayListOfIntsWritable();

        private AFormatReducer() {
        }

        public void reduce(IntWritable key, Iterator<HITSNode> values, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            this.adjList.clear();
            while (values.hasNext()) {
                this.valIn = values.next();
                ArrayListOfIntsWritable adjListIn = this.valIn.getInlinks();
                adjListIn.trimToSize();
                this.adjList.addUnique(adjListIn.getArray());
            }
            this.valOut.setType(2);
            this.valOut.setARank(0.0f);
            this.valOut.setInlinks(this.adjList);
            this.valOut.setNodeId(key.get());
            output.collect((Object)key, (Object)this.valOut);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AFormatMapperIMC
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, HITSNode> {
        private HITSNode valOut = new HITSNode();
        private IntWritable keyOut = new IntWritable();
        private static OutputCollector<IntWritable, HITSNode> mOutput;
        private static HMapIV<ArrayListOfIntsWritable> adjLists;
        Path[] cacheFiles;
        HashSet<Integer> stopList = new HashSet();

        private AFormatMapperIMC() {
        }

        public void configure(JobConf jc) {
            this.stopList = AFormatterWG.readStopList(jc);
            adjLists.clear();
        }

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            int curr;
            mOutput = output;
            ArrayListOfIntsWritable links = new ArrayListOfIntsWritable();
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            if (itr.hasMoreTokens()) {
                curr = Integer.parseInt(itr.nextToken());
                if (!this.stopList.contains(curr)) {
                    links.add(curr);
                } else {
                    return;
                }
            }
            while (itr.hasMoreTokens()) {
                curr = Integer.parseInt(itr.nextToken());
                if (this.stopList.contains(curr)) continue;
                if (adjLists.containsKey(curr)) {
                    ArrayListOfIntsWritable list = new ArrayListOfIntsWritable((ArrayListOfIntsWritable)adjLists.get(curr));
                    list.trimToSize();
                    links.trimToSize();
                    list.addUnique(links.getArray());
                    adjLists.remove(curr);
                    adjLists.put(curr, (Object)list);
                    continue;
                }
                links.trimToSize();
                adjLists.put(curr, (Object)links);
            }
        }

        public void close() throws IOException {
            for (MapIV.Entry e : adjLists.entrySet()) {
                this.keyOut.set(e.getKey());
                this.valOut.setNodeId(e.getKey());
                this.valOut.setARank(0.0f);
                this.valOut.setType(2);
                this.valOut.setInlinks((ArrayListOfIntsWritable)e.getValue());
                mOutput.collect((Object)this.keyOut, (Object)this.valOut);
            }
        }

        static {
            adjLists = new HMapIV();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AFormatMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, HITSNode> {
        private HITSNode valOut = new HITSNode();
        private IntWritable keyOut = new IntWritable();
        HashSet<Integer> stopList = new HashSet();

        private AFormatMapper() {
        }

        public void configure(JobConf jc) {
            this.stopList = AFormatterWG.readStopList(jc);
        }

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            ArrayListOfIntsWritable links = new ArrayListOfIntsWritable();
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            if (itr.hasMoreTokens()) {
                int curr = Integer.parseInt(itr.nextToken());
                if (this.stopList.contains(curr)) {
                    return;
                }
                links.add(curr);
                this.valOut.setInlinks(links);
                this.valOut.setARank(0.0f);
                this.valOut.setType(2);
            }
            while (itr.hasMoreTokens()) {
                this.keyOut.set(Integer.parseInt(itr.nextToken()));
                this.valOut.setNodeId(this.keyOut.get());
                if (this.stopList.contains(this.keyOut.get())) continue;
                output.collect((Object)this.keyOut, (Object)this.valOut);
            }
        }
    }
}

