/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.hits;

import edu.umd.cloud9.example.hits.HITSNode;
import edu.umd.cloud9.example.hits.RangePartitioner;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.array.ArrayListOfIntsWritable;
import tl.lin.data.map.HMapIF;
import tl.lin.data.map.MapIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HubsAndAuthoritiesSchimmy
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(HubsAndAuthoritiesSchimmy.class);
    private NumberFormat sFormat = new DecimalFormat("0000");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Float> readSums(JobConf jconf, String pathIn) throws Exception {
        ArrayList<Float> output = new ArrayList<Float>();
        float rootSumA = -1.0f;
        float rootSumH = -1.0f;
        SequenceFile.Reader reader = null;
        try {
            Configuration cfg = new Configuration();
            FileSystem fs = FileSystem.get((Configuration)cfg);
            Path sumsIn = new Path(pathIn);
            reader = new SequenceFile.Reader(fs, sumsIn, (Configuration)jconf);
            Text key = (Text)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)jconf);
            FloatWritable value = (FloatWritable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)jconf);
            while (reader.next((Writable)key, (Writable)value)) {
                if (key.toString().equals("A")) {
                    rootSumA = value.get();
                    continue;
                }
                if (key.toString().equals("H")) {
                    rootSumH = value.get();
                    continue;
                }
                System.out.println("PROBLEM");
            }
            IOUtils.closeStream((Closeable)reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeStream(reader);
        }
        if (rootSumA == -1.0f || rootSumH == -1.0f) {
            throw new Exception("error: rootSum == - 1");
        }
        output.add(new Float(rootSumA));
        output.add(new Float(rootSumH));
        return output;
    }

    private static float sumLogProbs(float a, float b) {
        if (a == Float.NEGATIVE_INFINITY) {
            return b;
        }
        if (b == Float.NEGATIVE_INFINITY) {
            return a;
        }
        if (a < b) {
            return (float)((double)b + StrictMath.log1p(StrictMath.exp(a - b)));
        }
        return (float)((double)a + StrictMath.log1p(StrictMath.exp(b - a)));
    }

    public int run(String[] args) throws Exception {
        if (args.length != 9) {
            HubsAndAuthoritiesSchimmy.printUsage();
            return -1;
        }
        String basePath = args[0];
        int n = Integer.parseInt(args[1]);
        int s = Integer.parseInt(args[2]);
        int e = Integer.parseInt(args[3]);
        boolean useCombiner = Integer.parseInt(args[4]) != 0;
        boolean useInmapCombiner = Integer.parseInt(args[5]) != 0;
        boolean useRange = Integer.parseInt(args[6]) != 0;
        int mapTasks = Integer.parseInt(args[7]);
        int reduceTasks = Integer.parseInt(args[8]);
        sLogger.info((Object)"Tool name: HubsAndAuthorities");
        sLogger.info((Object)(" - base dir: " + basePath));
        sLogger.info((Object)(" - node count: " + n));
        sLogger.info((Object)(" - start iteration: " + s));
        sLogger.info((Object)(" - end iteration: " + e));
        sLogger.info((Object)(" - useCombiner: " + useCombiner));
        sLogger.info((Object)(" - useInmapCombiner: " + useInmapCombiner));
        sLogger.info((Object)(" - useRange: " + useRange));
        sLogger.info((Object)(" - number of mappers: " + mapTasks));
        sLogger.info((Object)(" - number of reducers: " + reduceTasks));
        for (int i = s; i < e; ++i) {
            this.iterateHA(basePath, i, i + 1, n, useCombiner, useInmapCombiner, useRange, mapTasks, reduceTasks);
        }
        return 0;
    }

    private void iterateHA(String path, int i, int j, int n, boolean useCombiner, boolean useInmapCombiner, boolean useRange, int mapTasks, int reduceTasks) throws IOException {
        this.HACalc(path, i, j, n, useCombiner, useInmapCombiner, useRange, mapTasks, reduceTasks);
        this.Norm(path, i, j, n, useCombiner, useInmapCombiner, useRange, mapTasks, reduceTasks);
    }

    private static int printUsage() {
        System.out.println("usage: [base-path] [num-nodes] [start] [end] [useCombiner?] [useInMapCombiner?] [useRange?] [num-mappers] [num-reducers]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int HACalc(String path, int iter, int jter, int nodeCount, boolean useCombiner, boolean useInmapCombiner, boolean useRange, int mapTasks, int reduceTasks) throws IOException {
        JobConf conf = new JobConf(HubsAndAuthoritiesSchimmy.class);
        String inputPath = path + "/iter" + this.sFormat.format(iter);
        String outputPath = path + "/iter" + this.sFormat.format(jter) + "t";
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numPartitions = 0;
        for (FileStatus s : FileSystem.get((Configuration)conf).listStatus(new Path(inputPath))) {
            if (!s.getPath().getName().contains("part-")) continue;
            ++numPartitions;
        }
        conf.setInt("NodeCount", nodeCount);
        HashPartitioner p = null;
        if (useRange) {
            p = new RangePartitioner();
            p.configure(conf);
        } else {
            p = new HashPartitioner();
        }
        IntWritable key = new IntWritable();
        HITSNode value = new HITSNode();
        FileStatus[] status = fs.listStatus(new Path(inputPath));
        StringBuilder sb = new StringBuilder();
        for (FileStatus f : status) {
            if (f.getPath().getName().contains("_logs")) continue;
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, f.getPath(), (Configuration)conf);
            reader.next((Writable)key, (Writable)value);
            int np = p.getPartition((Object)key, (Object)value, numPartitions);
            reader.close();
            sLogger.info((Object)(f.getPath() + "\t" + np));
            sb.append(np + "=" + f.getPath() + "\t");
        }
        sLogger.info((Object)sb.toString().trim());
        sLogger.info((Object)"Tool: HubsAndAuthorities");
        sLogger.info((Object)(" - iteration: " + iter));
        sLogger.info((Object)(" - number of mappers: " + mapTasks));
        sLogger.info((Object)(" - number of reducers: " + reduceTasks));
        conf.setJobName("Iter" + iter + "HubsAndAuthorities");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(HITSNode.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        if (useInmapCombiner) {
            conf.setMapperClass(HAMapperIMC.class);
        } else {
            conf.setMapperClass(HAMapper.class);
        }
        if (useRange) {
            conf.setPartitionerClass(RangePartitioner.class);
        }
        conf.setReducerClass(HAReducer.class);
        conf.setInt("jobIter", iter);
        conf.setInt("NodeCount", nodeCount);
        conf.set("PartitionMapping", sb.toString().trim());
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        JobClient.runJob((JobConf)conf);
        sLogger.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        return 0;
    }

    public int Norm(String path, int iter, int jter, int nodeCount, boolean useCombiner, boolean useInmapCombiner, boolean useRange, int mapTasks, int reduceTasks) throws IOException {
        String inputPath = path + "/iter" + this.sFormat.format(jter) + "t";
        String outputPath = path + "/iter" + this.sFormat.format(jter);
        String tempPath = path + "/sqrt";
        sLogger.info((Object)"Tool: Normalizer");
        sLogger.info((Object)(" - input path: " + inputPath));
        sLogger.info((Object)(" - output path: " + outputPath));
        sLogger.info((Object)(" - iteration: " + iter));
        sLogger.info((Object)(" - number of mappers: " + mapTasks));
        sLogger.info((Object)(" - number of reducers: " + reduceTasks));
        JobConf conf = new JobConf(HubsAndAuthoritiesSchimmy.class);
        conf.setJobName("Iter" + iter + "NormalizerStep1");
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(tempPath));
        FileOutputFormat.setCompressOutput((JobConf)conf, (boolean)false);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(FloatWritable.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        if (useInmapCombiner) {
            conf.setMapperClass(Norm1MapperIMC.class);
        } else {
            conf.setMapperClass(Norm1Mapper.class);
        }
        if (useCombiner) {
            conf.setCombinerClass(Norm1Combiner.class);
        }
        conf.setReducerClass(Norm1Reducer.class);
        JobConf conf2 = new JobConf(HubsAndAuthoritiesSchimmy.class);
        conf2.setJobName("Iter" + iter + "NormalizerStep2");
        conf2.setInt("NodeCount", nodeCount);
        conf2.setNumMapTasks(mapTasks);
        conf2.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf2, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((JobConf)conf2, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((JobConf)conf2, (boolean)false);
        conf2.setInputFormat(SequenceFileInputFormat.class);
        conf2.setOutputKeyClass(IntWritable.class);
        conf2.setOutputValueClass(HITSNode.class);
        conf2.setOutputFormat(SequenceFileOutputFormat.class);
        conf2.setMapperClass(Norm2Mapper.class);
        if (useRange) {
            conf2.setPartitionerClass(RangePartitioner.class);
        }
        conf2.setReducerClass(IdentityReducer.class);
        Path tempDir = new Path(tempPath);
        FileSystem.get((Configuration)conf).delete(tempDir, true);
        long startTime = System.currentTimeMillis();
        JobClient.runJob((JobConf)conf);
        sLogger.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        Path outputDir = new Path(outputPath);
        ArrayList<Object> sums = new ArrayList();
        try {
            sums = this.readSums(conf2, tempPath + "/part-00000");
        }
        catch (Exception e) {
            System.err.println("Failed to read in Sums");
            System.exit(1);
        }
        conf2.setFloat("rootSumA", ((Float)sums.get(0)).floatValue());
        conf2.setFloat("rootSumH", ((Float)sums.get(1)).floatValue());
        FileSystem.get((Configuration)conf2).delete(outputDir, true);
        startTime = System.currentTimeMillis();
        JobClient.runJob((JobConf)conf2);
        sLogger.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new HubsAndAuthoritiesSchimmy(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Norm2Mapper
    extends MapReduceBase
    implements Mapper<IntWritable, HITSNode, IntWritable, HITSNode> {
        private HITSNode nodeOut = new HITSNode();
        private float rootSumA;
        private float rootSumH;

        private Norm2Mapper() {
        }

        public void configure(JobConf jconf) {
            this.rootSumA = jconf.getFloat("rootSumA", 0.0f);
            this.rootSumH = jconf.getFloat("rootSumH", 0.0f);
        }

        public void map(IntWritable key, HITSNode value, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            float arank = value.getARank();
            float hrank = value.getHRank();
            this.nodeOut.setNodeId(key.get());
            this.nodeOut.setType(7);
            this.nodeOut.setARank(arank -= this.rootSumA);
            this.nodeOut.setHRank(hrank -= this.rootSumH);
            this.nodeOut.setInlinks(value.getInlinks());
            this.nodeOut.setOutlinks(value.getOutlinks());
            output.collect((Object)key, (Object)this.nodeOut);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Norm1Reducer
    extends MapReduceBase
    implements Reducer<Text, FloatWritable, Text, FloatWritable> {
        private Norm1Reducer() {
        }

        public void reduce(Text key, Iterator<FloatWritable> values, OutputCollector<Text, FloatWritable> output, Reporter reporter) throws IOException {
            float sum = Float.NEGATIVE_INFINITY;
            while (values.hasNext()) {
                FloatWritable valIn = values.next();
                sum = HubsAndAuthoritiesSchimmy.sumLogProbs(sum, valIn.get());
            }
            output.collect((Object)key, (Object)new FloatWritable(sum /= 2.0f));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Norm1Combiner
    extends MapReduceBase
    implements Reducer<Text, FloatWritable, Text, FloatWritable> {
        private Norm1Combiner() {
        }

        public void reduce(Text key, Iterator<FloatWritable> values, OutputCollector<Text, FloatWritable> output, Reporter reporter) throws IOException {
            float sum = Float.NEGATIVE_INFINITY;
            while (values.hasNext()) {
                FloatWritable valIn = values.next();
                sum = HubsAndAuthoritiesSchimmy.sumLogProbs(sum, valIn.get());
            }
            if (sum != Float.NEGATIVE_INFINITY) {
                output.collect((Object)key, (Object)new FloatWritable(sum));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Norm1MapperIMC
    extends MapReduceBase
    implements Mapper<IntWritable, HITSNode, Text, FloatWritable> {
        private static float hsum = Float.NEGATIVE_INFINITY;
        private static float asum = Float.NEGATIVE_INFINITY;
        private static OutputCollector<Text, FloatWritable> mOutput;

        private Norm1MapperIMC() {
        }

        public void configure(JobConf conf) {
            hsum = Float.NEGATIVE_INFINITY;
            asum = Float.NEGATIVE_INFINITY;
        }

        public void map(IntWritable key, HITSNode value, OutputCollector<Text, FloatWritable> output, Reporter reporter) throws IOException {
            mOutput = output;
            int type = value.getType();
            float arank = value.getARank() * 2.0f;
            float hrank = value.getHRank() * 2.0f;
            if (type == 7) {
                asum = HubsAndAuthoritiesSchimmy.sumLogProbs(Norm1MapperIMC.asum, arank);
                hsum = HubsAndAuthoritiesSchimmy.sumLogProbs(Norm1MapperIMC.hsum, hrank);
            } else {
                System.err.println("Bad Type: " + type);
            }
        }

        public void close() throws IOException {
            if (hsum != Float.NEGATIVE_INFINITY) {
                mOutput.collect((Object)new Text("H"), (Object)new FloatWritable(hsum));
            }
            if (asum != Float.NEGATIVE_INFINITY) {
                mOutput.collect((Object)new Text("A"), (Object)new FloatWritable(asum));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Norm1Mapper
    extends MapReduceBase
    implements Mapper<IntWritable, HITSNode, Text, FloatWritable> {
        FloatWritable rank = new FloatWritable();

        private Norm1Mapper() {
        }

        public void map(IntWritable key, HITSNode value, OutputCollector<Text, FloatWritable> output, Reporter reporter) throws IOException {
            int type = value.getType();
            if (type == 7) {
                this.rank.set(value.getARank() * 2.0f);
                output.collect((Object)new Text("A"), (Object)this.rank);
                this.rank.set(value.getHRank() * 2.0f);
                output.collect((Object)new Text("H"), (Object)this.rank);
            } else {
                System.err.println("Bad Type: " + type);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HAReducer
    extends MapReduceBase
    implements Reducer<IntWritable, HITSNode, IntWritable, HITSNode> {
        private HITSNode valIn;
        private HITSNode valOut = new HITSNode();
        private OutputCollector<IntWritable, HITSNode> mOutput;
        private Reporter mReporter;
        private JobConf mJobConf;
        private String mTaskId;
        private SequenceFile.Reader reader;
        private IntWritable mStateNid = new IntWritable();
        private HITSNode mStateNode = new HITSNode();
        private int jobIter = 0;

        private HAReducer() {
        }

        public void configure(JobConf jconf) {
            this.mJobConf = jconf;
            this.mTaskId = jconf.get("mapred.task.id");
            this.jobIter = jconf.getInt("jobIter", 0);
            String pMappingString = jconf.get("PartitionMapping");
            HashMap<Integer, String> m = new HashMap<Integer, String>();
            for (String s : pMappingString.split("\\t")) {
                String[] arr = s.split("=");
                sLogger.info((Object)(arr[0] + "\t" + arr[1]));
                m.put(Integer.parseInt(arr[0]), arr[1]);
            }
            int partno = Integer.parseInt(this.mTaskId.substring(this.mTaskId.length() - 7, this.mTaskId.length() - 2));
            String f = (String)m.get(partno);
            sLogger.info((Object)("task id: " + this.mTaskId));
            sLogger.info((Object)("partno: " + partno));
            sLogger.info((Object)("file: " + f));
            try {
                FileSystem fs = FileSystem.get((Configuration)jconf);
                this.reader = new SequenceFile.Reader(fs, new Path(f), (Configuration)jconf);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Couldn't open + " + f + " for partno: " + partno + " within: " + this.mTaskId);
            }
        }

        public void reduce(IntWritable key, Iterator<HITSNode> values, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            ArrayListOfIntsWritable adjList = new ArrayListOfIntsWritable();
            float hrank = Float.NEGATIVE_INFINITY;
            float arank = Float.NEGATIVE_INFINITY;
            this.valOut.setInlinks(adjList);
            this.valOut.setOutlinks(adjList);
            this.mOutput = output;
            this.mReporter = reporter;
            while (this.reader.next((Writable)this.mStateNid, (Writable)this.mStateNode) && this.mStateNid.get() != key.get()) {
                if (this.mStateNid.get() <= key.get()) continue;
                HashPartitioner p = new HashPartitioner();
                int sp = p.getPartition((Object)this.mStateNid, (Object)this.mStateNode, this.mJobConf.getNumReduceTasks());
                int kp = p.getPartition((Object)key, (Object)this.mStateNode, this.mJobConf.getNumReduceTasks());
                throw new RuntimeException("Unexpected Schimmy failure during merge! nids: " + this.mStateNid.get() + " " + key.get() + " parts: " + sp + " " + kp);
            }
            while (values.hasNext()) {
                this.valIn = values.next();
                int type = this.valIn.getType();
                float arankIn = this.valIn.getARank();
                float hrankIn = this.valIn.getHRank();
                if (type == 3) {
                    hrank = HubsAndAuthoritiesSchimmy.sumLogProbs(hrank, hrankIn);
                    continue;
                }
                if (type != 4) continue;
                arank = HubsAndAuthoritiesSchimmy.sumLogProbs(arank, arankIn);
            }
            if (this.jobIter == 0) {
                if (hrank == Float.NEGATIVE_INFINITY) {
                    hrank = 0.0f;
                }
                if (arank == Float.NEGATIVE_INFINITY) {
                    arank = 0.0f;
                }
            }
            if (this.mStateNode.getType() == 7) {
                this.valOut.setInlinks(this.mStateNode.getInlinks());
                this.valOut.setOutlinks(this.mStateNode.getOutlinks());
            }
            this.valOut.setHRank(hrank);
            this.valOut.setARank(arank);
            this.valOut.setType(7);
            this.valOut.setNodeId(key.get());
            output.collect((Object)key, (Object)this.valOut);
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HAMapperIMC
    extends MapReduceBase
    implements Mapper<IntWritable, HITSNode, IntWritable, HITSNode> {
        private static HMapIF rankmapA = new HMapIF();
        private static HMapIF rankmapH = new HMapIF();
        private static OutputCollector<IntWritable, HITSNode> mOutput;
        private static HITSNode valOut;

        private HAMapperIMC() {
        }

        public void configure(JobConf job) {
            rankmapA.clear();
            rankmapH.clear();
        }

        public void map(IntWritable key, HITSNode value, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            int curr;
            int i;
            mOutput = output;
            valOut.setNodeId(value.getNodeId());
            valOut.setType(8);
            valOut.setARank(value.getARank());
            valOut.setHRank(value.getHRank());
            output.collect((Object)key, (Object)valOut);
            ArrayListOfIntsWritable adjList = value.getOutlinks();
            for (i = 0; i < adjList.size(); ++i) {
                curr = adjList.get(i);
                if (rankmapA.containsKey(curr)) {
                    rankmapA.put(curr, HubsAndAuthoritiesSchimmy.sumLogProbs(HAMapperIMC.rankmapA.get(curr), value.getHRank()));
                    continue;
                }
                rankmapA.put(curr, value.getHRank());
            }
            adjList = value.getInlinks();
            for (i = 0; i < adjList.size(); ++i) {
                curr = adjList.get(i);
                if (rankmapH.containsKey(curr)) {
                    rankmapH.put(curr, HubsAndAuthoritiesSchimmy.sumLogProbs(HAMapperIMC.rankmapH.get(curr), value.getARank()));
                    continue;
                }
                rankmapH.put(curr, value.getARank());
            }
        }

        public void close() throws IOException {
            IntWritable n = new IntWritable();
            HITSNode mass = new HITSNode();
            for (MapIF.Entry e : rankmapH.entrySet()) {
                n.set(e.getKey());
                mass.setType(3);
                mass.setHRank(e.getValue());
                mass.setNodeId(e.getKey());
                mOutput.collect((Object)n, (Object)mass);
            }
            for (MapIF.Entry e : rankmapA.entrySet()) {
                n.set(e.getKey());
                mass.setType(4);
                mass.setARank(e.getValue());
                mass.setNodeId(e.getKey());
                mOutput.collect((Object)n, (Object)mass);
            }
        }

        static {
            valOut = new HITSNode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HAMapper
    extends MapReduceBase
    implements Mapper<IntWritable, HITSNode, IntWritable, HITSNode> {
        private HITSNode valOut = new HITSNode();
        private ArrayListOfIntsWritable empty = new ArrayListOfIntsWritable();

        private HAMapper() {
        }

        public void map(IntWritable key, HITSNode value, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            int curr;
            int i;
            int typeOut = 0;
            this.valOut.setType(typeOut);
            this.valOut.setARank(value.getARank());
            this.valOut.setHRank(value.getHRank());
            this.valOut.setType(8);
            this.valOut.setNodeId(value.getNodeId());
            output.collect((Object)key, (Object)this.valOut);
            typeOut = 4;
            ArrayListOfIntsWritable adjList = value.getOutlinks();
            for (i = 0; i < adjList.size(); ++i) {
                curr = adjList.get(i);
                this.valOut.setType(typeOut);
                this.valOut.setARank(value.getHRank());
                output.collect((Object)new IntWritable(curr), (Object)this.valOut);
            }
            typeOut = 3;
            adjList = value.getInlinks();
            for (i = 0; i < adjList.size(); ++i) {
                curr = adjList.get(i);
                this.valOut.setType(typeOut);
                this.valOut.setHRank(value.getARank());
                output.collect((Object)new IntWritable(curr), (Object)this.valOut);
            }
        }
    }
}

