/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.hits;

import edu.umd.cloud9.example.hits.HITSNode;
import edu.umd.cloud9.example.hits.RangePartitioner;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class PartitionGraph
extends Configured
implements Tool {
    private static final Logger sLogger = Logger.getLogger(PartitionGraph.class);

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new PartitionGraph(), (String[])args);
        System.exit(res);
    }

    private static int printUsage() {
        System.out.println("usage: [in-path] [out-path] [numPartitions] [useRange?] [nodeCount]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws IOException {
        if (args.length != 5) {
            PartitionGraph.printUsage();
            return -1;
        }
        String inPath = args[0];
        String outPath = args[1];
        int numParts = Integer.parseInt(args[2]);
        boolean useRange = Integer.parseInt(args[3]) != 0;
        int nodeCount = Integer.parseInt(args[4]);
        sLogger.info((Object)"Tool name: PartitionGraph");
        sLogger.info((Object)(" - in dir: " + inPath));
        sLogger.info((Object)(" - out dir: " + outPath));
        sLogger.info((Object)(" - numParts: " + numParts));
        sLogger.info((Object)(" - useRange: " + useRange));
        sLogger.info((Object)(" - nodeCnt: " + nodeCount));
        JobConf conf = new JobConf(PartitionGraph.class);
        conf.setJobName("Partition Graph " + numParts);
        conf.setNumReduceTasks(numParts);
        conf.setInt("mapred.min.split.size", 0x40000000);
        conf.set("mapred.child.java.opts", "-Xmx2048m");
        conf.setInt("NodeCount", nodeCount);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inPath)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outPath));
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(HITSNode.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(HITSNode.class);
        conf.setMapperClass(MapClass.class);
        conf.setReducerClass(ReduceClass.class);
        conf.setSpeculativeExecution(false);
        if (useRange) {
            conf.setPartitionerClass(RangePartitioner.class);
        }
        FileSystem.get((Configuration)conf).delete(new Path(outPath), true);
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReduceClass
    extends MapReduceBase
    implements Reducer<IntWritable, HITSNode, IntWritable, HITSNode> {
        private ReduceClass() {
        }

        public void reduce(IntWritable nid, Iterator<HITSNode> values, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                HITSNode node = values.next();
                output.collect((Object)nid, (Object)node);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapClass
    extends MapReduceBase
    implements Mapper<IntWritable, HITSNode, IntWritable, HITSNode> {
        private MapClass() {
        }

        public void map(IntWritable nid, HITSNode node, OutputCollector<IntWritable, HITSNode> output, Reporter reporter) throws IOException {
            output.collect((Object)nid, (Object)node);
        }
    }
}

