/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.ir;

import edu.umd.cloud9.example.ir.LookupPostings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import tl.lin.data.array.ArrayListWritable;
import tl.lin.data.pair.PairOfInts;
import tl.lin.data.pair.PairOfWritables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanRetrieval
extends Configured
implements Tool {
    private MapFile.Reader index;
    private FSDataInputStream collection;
    private Stack<Set<Integer>> stack;
    private static final String INDEX = "index";
    private static final String COLLECTION = "collection";

    private BooleanRetrieval() {
    }

    private void initialize(String indexPath, String collectionPath, FileSystem fs) throws IOException {
        this.index = new MapFile.Reader(new Path(indexPath + "/part-r-00000"), fs.getConf(), new SequenceFile.Reader.Option[0]);
        this.collection = fs.open(new Path(collectionPath));
        this.stack = new Stack();
    }

    private void runQuery(String q) throws IOException {
        String[] terms;
        for (String t : terms = q.split("\\s+")) {
            if (t.equals("AND")) {
                this.performAND();
                continue;
            }
            if (t.equals("OR")) {
                this.performOR();
                continue;
            }
            this.pushTerm(t);
        }
        Set<Integer> set = this.stack.pop();
        for (Integer i : set) {
            String line = this.fetchLine(i.intValue());
            System.out.println(i + "\t" + line);
        }
    }

    private void pushTerm(String term) throws IOException {
        this.stack.push(this.fetchDocumentSet(term));
    }

    private void performAND() {
        Set<Integer> s1 = this.stack.pop();
        Set<Integer> s2 = this.stack.pop();
        TreeSet<Integer> sn = new TreeSet<Integer>();
        for (int n : s1) {
            if (!s2.contains(n)) continue;
            sn.add(n);
        }
        this.stack.push(sn);
    }

    private void performOR() {
        Set<Integer> s1 = this.stack.pop();
        Set<Integer> s2 = this.stack.pop();
        TreeSet<Integer> sn = new TreeSet<Integer>();
        for (int n : s1) {
            sn.add(n);
        }
        for (int n : s2) {
            sn.add(n);
        }
        this.stack.push(sn);
    }

    private Set<Integer> fetchDocumentSet(String term) throws IOException {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (PairOfInts pair : this.fetchPostings(term)) {
            set.add(pair.getLeftElement());
        }
        return set;
    }

    private ArrayListWritable<PairOfInts> fetchPostings(String term) throws IOException {
        Text key = new Text();
        PairOfWritables value = new PairOfWritables();
        key.set(term);
        this.index.get((WritableComparable)key, (Writable)value);
        return (ArrayListWritable)value.getRightElement();
    }

    private String fetchLine(long offset) throws IOException {
        this.collection.seek(offset);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.collection));
        return reader.readLine();
    }

    public int run(String[] args) throws Exception {
        String[] queries;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INDEX));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)COLLECTION));
        CommandLine cmdline = null;
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            System.exit(-1);
        }
        if (!cmdline.hasOption(INDEX) || !cmdline.hasOption(COLLECTION)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(LookupPostings.class.getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            System.exit(-1);
        }
        String indexPath = cmdline.getOptionValue(INDEX);
        String collectionPath = cmdline.getOptionValue(COLLECTION);
        if (collectionPath.endsWith(".gz")) {
            System.out.println("gzipped collection is not seekable: use compressed version!");
            System.exit(-1);
        }
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        this.initialize(indexPath, collectionPath, fs);
        for (String q : queries = new String[]{"outrageous fortune AND", "white rose AND", "means deceit AND", "white red OR rose AND pluck AND", "unhappy outrageous OR good your AND OR fortune AND"}) {
            System.out.println("Query: " + q);
            this.runQuery(q);
            System.out.println("");
        }
        return 1;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new BooleanRetrieval(), (String[])args);
    }
}

