/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.ir;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.array.ArrayListWritable;
import tl.lin.data.fd.Object2IntFrequencyDistribution;
import tl.lin.data.fd.Object2IntFrequencyDistributionEntry;
import tl.lin.data.pair.PairOfInts;
import tl.lin.data.pair.PairOfObjectInt;
import tl.lin.data.pair.PairOfWritables;

public class BuildInvertedIndex
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(BuildInvertedIndex.class);
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String NUM_REDUCERS = "numReducers";

    private BuildInvertedIndex() {
    }

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of reducers");
        options.addOption(OptionBuilder.create((String)NUM_REDUCERS));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT) || !cmdline.hasOption(OUTPUT)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT);
        String outputPath = cmdline.getOptionValue(OUTPUT);
        int reduceTasks = cmdline.hasOption(NUM_REDUCERS) ? Integer.parseInt(cmdline.getOptionValue(NUM_REDUCERS)) : 1;
        LOG.info((Object)("Tool name: " + BuildInvertedIndex.class.getSimpleName()));
        LOG.info((Object)(" - input path: " + inputPath));
        LOG.info((Object)(" - output path: " + outputPath));
        LOG.info((Object)(" - num reducers: " + reduceTasks));
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName(BuildInvertedIndex.class.getSimpleName());
        job.setJarByClass(BuildInvertedIndex.class);
        job.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(PairOfInts.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(PairOfWritables.class);
        job.setOutputFormatClass(MapFileOutputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)this.getConf()).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        System.out.println("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new BuildInvertedIndex(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer
    extends Reducer<Text, PairOfInts, Text, PairOfWritables<IntWritable, ArrayListWritable<PairOfInts>>> {
        private static final IntWritable DF = new IntWritable();

        private MyReducer() {
        }

        public void reduce(Text key, Iterable<PairOfInts> values, Reducer.Context context) throws IOException, InterruptedException {
            Iterator<PairOfInts> iter = values.iterator();
            ArrayListWritable postings = new ArrayListWritable();
            int df = 0;
            while (iter.hasNext()) {
                postings.add((Object)iter.next().clone());
                ++df;
            }
            Collections.sort(postings);
            DF.set(df);
            context.write((Object)key, (Object)new PairOfWritables((Writable)DF, (Writable)postings));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends Mapper<LongWritable, Text, Text, PairOfInts> {
        private static final Text WORD = new Text();
        private static final Object2IntFrequencyDistribution<String> COUNTS = new Object2IntFrequencyDistributionEntry();

        private MyMapper() {
        }

        public void map(LongWritable docno, Text doc, Mapper.Context context) throws IOException, InterruptedException {
            String[] terms;
            String text = doc.toString();
            COUNTS.clear();
            for (String term : terms = text.split("\\s+")) {
                if (term == null || term.length() == 0) continue;
                COUNTS.increment((Comparable)((Object)term));
            }
            for (PairOfObjectInt e : COUNTS) {
                WORD.set((String)((Object)e.getLeftElement()));
                context.write((Object)WORD, (Object)new PairOfInts((int)docno.get(), e.getRightElement()));
            }
        }
    }
}

