/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.ir;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import tl.lin.data.array.ArrayListWritable;
import tl.lin.data.fd.Int2IntFrequencyDistributionEntry;
import tl.lin.data.pair.PairOfInts;
import tl.lin.data.pair.PairOfWritables;

public class LookupPostings
extends Configured
implements Tool {
    private static final String INDEX = "index";
    private static final String COLLECTION = "collection";

    private LookupPostings() {
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INDEX));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)COLLECTION));
        CommandLine cmdline = null;
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            System.exit(-1);
        }
        if (!cmdline.hasOption(INDEX) || !cmdline.hasOption(COLLECTION)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(LookupPostings.class.getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            System.exit(-1);
        }
        String indexPath = cmdline.getOptionValue(INDEX);
        String collectionPath = cmdline.getOptionValue(COLLECTION);
        if (collectionPath.endsWith(".gz")) {
            System.out.println("gzipped collection is not seekable: use compressed version!");
            System.exit(-1);
        }
        Configuration config = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)config);
        MapFile.Reader reader = new MapFile.Reader(new Path(indexPath + "/part-r-00000"), config, new SequenceFile.Reader.Option[0]);
        FSDataInputStream collection = fs.open(new Path(collectionPath));
        BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)collection));
        Text key = new Text();
        PairOfWritables value = new PairOfWritables();
        System.out.println("Looking up postings for the term \"starcross'd\"");
        key.set("starcross'd");
        reader.get((WritableComparable)key, (Writable)value);
        ArrayListWritable postings = (ArrayListWritable)value.getRightElement();
        for (PairOfInts pair : postings) {
            System.out.println(pair);
            collection.seek((long)pair.getLeftElement());
            System.out.println(d.readLine());
        }
        key.set("gold");
        reader.get((WritableComparable)key, (Writable)value);
        System.out.println("Complete postings list for 'gold': " + value);
        Int2IntFrequencyDistributionEntry goldHist = new Int2IntFrequencyDistributionEntry();
        postings = (ArrayListWritable)value.getRightElement();
        for (PairOfInts pair : postings) {
            goldHist.increment(pair.getRightElement());
        }
        System.out.println("histogram of tf values for gold");
        for (PairOfInts pair : goldHist) {
            System.out.println(pair.getLeftElement() + "\t" + pair.getRightElement());
        }
        key.set("silver");
        reader.get((WritableComparable)key, (Writable)value);
        System.out.println("Complete postings list for 'silver': " + value);
        Int2IntFrequencyDistributionEntry silverHist = new Int2IntFrequencyDistributionEntry();
        postings = (ArrayListWritable)value.getRightElement();
        for (PairOfInts pair : postings) {
            silverHist.increment(pair.getRightElement());
        }
        System.out.println("histogram of tf values for silver");
        for (PairOfInts pair : silverHist) {
            System.out.println(pair.getLeftElement() + "\t" + pair.getRightElement());
        }
        key.set("bronze");
        Writable w = reader.get((WritableComparable)key, (Writable)value);
        if (w == null) {
            System.out.println("the term bronze does not appear in the collection");
        }
        collection.close();
        reader.close();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new LookupPostings(), (String[])args);
    }
}

