/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import edu.umd.cloud9.example.pagerank.PageRankNode;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class DumpPageRankRecordsToPlainText
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(DumpPageRankRecordsToPlainText.class);
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!cmdline.hasOption(INPUT) || !cmdline.hasOption(OUTPUT)) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT);
        String outputPath = cmdline.getOptionValue(OUTPUT);
        LOG.info((Object)("Tool name: " + DumpPageRankRecordsToPlainText.class.getSimpleName()));
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output: " + outputPath));
        Configuration conf = new Configuration();
        conf.setInt("mapred.min.split.size", 0x40000000);
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName(DumpPageRankRecordsToPlainText.class.getSimpleName());
        job.setJarByClass(DumpPageRankRecordsToPlainText.class);
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(PageRankNode.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new DumpPageRankRecordsToPlainText(), (String[])args);
    }
}

