/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import edu.umd.cloud9.example.pagerank.PageRankNode;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.pair.PairOfObjectFloat;
import tl.lin.data.queue.TopScoredObjects;

public class FindMaxPageRankNodes
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(FindMaxPageRankNodes.class);
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String TOP = "top";

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"top n");
        options.addOption(OptionBuilder.create((String)TOP));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(INPUT) && cmdline.hasOption(OUTPUT) && cmdline.hasOption(TOP))) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inputPath = cmdline.getOptionValue(INPUT);
        String outputPath = cmdline.getOptionValue(OUTPUT);
        int n = Integer.parseInt(cmdline.getOptionValue(TOP));
        LOG.info((Object)("Tool name: " + FindMaxPageRankNodes.class.getSimpleName()));
        LOG.info((Object)(" - input: " + inputPath));
        LOG.info((Object)(" - output: " + outputPath));
        LOG.info((Object)(" - top: " + n));
        Configuration conf = this.getConf();
        conf.setInt("mapred.min.split.size", 0x40000000);
        conf.setInt("n", n);
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName(FindMaxPageRankNodes.class.getName() + ":" + inputPath);
        job.setJarByClass(FindMaxPageRankNodes.class);
        job.setNumReduceTasks(1);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(FloatWritable.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(FloatWritable.class);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        FileSystem.get((Configuration)conf).delete(new Path(outputPath), true);
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new FindMaxPageRankNodes(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReducer
    extends Reducer<IntWritable, FloatWritable, IntWritable, FloatWritable> {
        private static TopScoredObjects<Integer> queue;

        private MyReducer() {
        }

        public void setup(Reducer.Context context) throws IOException {
            int k = context.getConfiguration().getInt("n", 100);
            queue = new TopScoredObjects(k);
        }

        public void reduce(IntWritable nid, Iterable<FloatWritable> iterable, Reducer.Context context) throws IOException {
            Iterator<FloatWritable> iter = iterable.iterator();
            queue.add((Comparable)Integer.valueOf(nid.get()), iter.next().get());
            if (iter.hasNext()) {
                throw new RuntimeException();
            }
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            IntWritable key = new IntWritable();
            FloatWritable value = new FloatWritable();
            for (PairOfObjectFloat pair : queue.extractAll()) {
                key.set(((Integer)pair.getLeftElement()).intValue());
                value.set(pair.getRightElement());
                context.write((Object)key, (Object)value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends Mapper<IntWritable, PageRankNode, IntWritable, FloatWritable> {
        private TopScoredObjects<Integer> queue;

        private MyMapper() {
        }

        public void setup(Mapper.Context context) throws IOException {
            int k = context.getConfiguration().getInt("n", 100);
            this.queue = new TopScoredObjects(k);
        }

        public void map(IntWritable nid, PageRankNode node, Mapper.Context context) throws IOException, InterruptedException {
            this.queue.add((Comparable)Integer.valueOf(node.getNodeId()), node.getPageRank());
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            IntWritable key = new IntWritable();
            FloatWritable value = new FloatWritable();
            for (PairOfObjectFloat pair : this.queue.extractAll()) {
                key.set(((Integer)pair.getLeftElement()).intValue());
                value.set(pair.getRightElement());
                context.write((Object)key, (Object)value);
            }
        }
    }
}

