/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import tl.lin.data.array.ArrayListOfIntsWritable;

public class PageRankNode
implements Writable {
    private static final Type[] mapping = new Type[]{Type.Complete, Type.Mass, Type.Structure};
    private Type type;
    private int nodeid;
    private float pagerank;
    private ArrayListOfIntsWritable adjacenyList;

    public float getPageRank() {
        return this.pagerank;
    }

    public void setPageRank(float p) {
        this.pagerank = p;
    }

    public int getNodeId() {
        return this.nodeid;
    }

    public void setNodeId(int n) {
        this.nodeid = n;
    }

    public ArrayListOfIntsWritable getAdjacenyList() {
        return this.adjacenyList;
    }

    public void setAdjacencyList(ArrayListOfIntsWritable list) {
        this.adjacenyList = list;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void readFields(DataInput in) throws IOException {
        byte b = in.readByte();
        this.type = mapping[b];
        this.nodeid = in.readInt();
        if (this.type.equals((Object)Type.Mass)) {
            this.pagerank = in.readFloat();
            return;
        }
        if (this.type.equals((Object)Type.Complete)) {
            this.pagerank = in.readFloat();
        }
        this.adjacenyList = new ArrayListOfIntsWritable();
        this.adjacenyList.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.type.val);
        out.writeInt(this.nodeid);
        if (this.type.equals((Object)Type.Mass)) {
            out.writeFloat(this.pagerank);
            return;
        }
        if (this.type.equals((Object)Type.Complete)) {
            out.writeFloat(this.pagerank);
        }
        this.adjacenyList.write(out);
    }

    public String toString() {
        return String.format("{%d %.4f %s}", this.nodeid, Float.valueOf(this.pagerank), this.adjacenyList == null ? "[]" : this.adjacenyList.toString(10));
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static PageRankNode create(DataInput in) throws IOException {
        PageRankNode m = new PageRankNode();
        m.readFields(in);
        return m;
    }

    public static PageRankNode create(byte[] bytes) throws IOException {
        return PageRankNode.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Complete(0),
        Mass(1),
        Structure(2);

        public byte val;

        private Type(byte v) {
            this.val = v;
        }
    }
}

